/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;

public final class ProductGroupLinkContractImpl
implements ProductGroupLinkContract,
ProductGroupLinkContract.Definition,
ProductGroupLinkContract.Update {
    private ProductGroupLinkContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String productId;
    private String groupLinkId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String groupId() {
        return this.innerModel().groupId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ProductGroupLinkContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProductGroupLinkContractImpl withExistingProduct(String resourceGroupName, String serviceName, String productId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.productId = productId;
        return this;
    }

    @Override
    public ProductGroupLinkContract create() {
        this.innerObject = (ProductGroupLinkContractInner)((Object)this.serviceManager.serviceClient().getProductGroupLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProductGroupLinkContract create(Context context) {
        this.innerObject = (ProductGroupLinkContractInner)((Object)this.serviceManager.serviceClient().getProductGroupLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, this.innerModel(), context).getValue());
        return this;
    }

    ProductGroupLinkContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ProductGroupLinkContractInner();
        this.serviceManager = serviceManager;
        this.groupLinkId = name;
    }

    @Override
    public ProductGroupLinkContractImpl update() {
        return this;
    }

    @Override
    public ProductGroupLinkContract apply() {
        this.innerObject = (ProductGroupLinkContractInner)((Object)this.serviceManager.serviceClient().getProductGroupLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProductGroupLinkContract apply(Context context) {
        this.innerObject = (ProductGroupLinkContractInner)((Object)this.serviceManager.serviceClient().getProductGroupLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, this.innerModel(), context).getValue());
        return this;
    }

    ProductGroupLinkContractImpl(ProductGroupLinkContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.productId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "products");
        this.groupLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "groupLinks");
    }

    @Override
    public ProductGroupLinkContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getProductGroupLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ProductGroupLinkContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProductGroupLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.productId, this.groupLinkId, context).getValue();
        return this;
    }

    @Override
    public ProductGroupLinkContractImpl withGroupId(String groupId) {
        this.innerModel().withGroupId(groupId);
        return this;
    }
}

