/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import com.azure.resourcemanager.apimanagement.models.ProductPolicies;
import com.azure.resourcemanager.apimanagement.models.ProductPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ProductPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ProductPoliciesGetResponse;

public final class ProductPoliciesImpl
implements ProductPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ProductPoliciesImpl.class);
    private final ProductPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductPoliciesImpl(ProductPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyContract> listByProduct(String resourceGroupName, String serviceName, String productId, Context context) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ProductPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, productId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, productId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        ProductPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, productId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, productId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        ProductPoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, productId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, productId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, productId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String productId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, productId, policyId, ifMatch);
    }

    private ProductPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

