/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ProductWikisOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.WikiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.WikiContractImpl;
import com.azure.resourcemanager.apimanagement.models.ProductWikisOperations;
import com.azure.resourcemanager.apimanagement.models.WikiContract;

public final class ProductWikisOperationsImpl
implements ProductWikisOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ProductWikisOperationsImpl.class);
    private final ProductWikisOperationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ProductWikisOperationsImpl(ProductWikisOperationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<WikiContract> list(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<WikiContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WikiContractImpl((WikiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WikiContract> list(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<WikiContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WikiContractImpl((WikiContractInner)((Object)inner1), this.manager()));
    }

    private ProductWikisOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

