/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.QuotaByPeriodKeysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.QuotaCounterContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.QuotaCounterValueUpdateContract;
import reactor.core.publisher.Mono;

public final class QuotaByPeriodKeysClientImpl
implements QuotaByPeriodKeysClient {
    private final QuotaByPeriodKeysService service;
    private final ApiManagementClientImpl client;

    QuotaByPeriodKeysClientImpl(ApiManagementClientImpl client) {
        this.service = (QuotaByPeriodKeysService)RestProxy.create(QuotaByPeriodKeysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterContractInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (quotaPeriodKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaPeriodKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterContractInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (quotaPeriodKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaPeriodKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QuotaCounterContractInner> getAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey).flatMap(res -> Mono.justOrEmpty((Object)((QuotaCounterContractInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaCounterContractInner> getWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaCounterContractInner get(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey) {
        return (QuotaCounterContractInner)this.getWithResponse(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterContractInner>> updateWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (quotaPeriodKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaPeriodKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaCounterContractInner>> updateWithResponseAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (quotaCounterKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaCounterKey is required and cannot be null."));
        }
        if (quotaPeriodKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaPeriodKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QuotaCounterContractInner> updateAsync(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters) {
        return this.updateWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, parameters).flatMap(res -> Mono.justOrEmpty((Object)((QuotaCounterContractInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaCounterContractInner> updateWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaCounterContractInner update(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters) {
        return (QuotaCounterContractInner)this.updateWithResponse(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientQ")
    public static interface QuotaByPeriodKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QuotaCounterContractInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="quotaCounterKey") String var4, @PathParam(value="quotaPeriodKey") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QuotaCounterContractInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="quotaCounterKey") String var4, @PathParam(value="quotaPeriodKey") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") QuotaCounterValueUpdateContract var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

