/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.QuotaByPeriodKeysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.QuotaCounterContractInner;
import com.azure.resourcemanager.apimanagement.implementation.QuotaCounterContractImpl;
import com.azure.resourcemanager.apimanagement.models.QuotaByPeriodKeys;
import com.azure.resourcemanager.apimanagement.models.QuotaCounterContract;
import com.azure.resourcemanager.apimanagement.models.QuotaCounterValueUpdateContract;

public final class QuotaByPeriodKeysImpl
implements QuotaByPeriodKeys {
    private static final ClientLogger LOGGER = new ClientLogger(QuotaByPeriodKeysImpl.class);
    private final QuotaByPeriodKeysClient innerClient;
    private final ApiManagementManager serviceManager;

    public QuotaByPeriodKeysImpl(QuotaByPeriodKeysClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<QuotaCounterContract> getWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, Context context) {
        Response<QuotaCounterContractInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QuotaCounterContractImpl((QuotaCounterContractInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public QuotaCounterContract get(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey) {
        QuotaCounterContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey);
        if (inner != null) {
            return new QuotaCounterContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<QuotaCounterContract> updateWithResponse(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters, Context context) {
        Response<QuotaCounterContractInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QuotaCounterContractImpl((QuotaCounterContractInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public QuotaCounterContract update(String resourceGroupName, String serviceName, String quotaCounterKey, String quotaPeriodKey, QuotaCounterValueUpdateContract parameters) {
        QuotaCounterContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, quotaCounterKey, quotaPeriodKey, parameters);
        if (inner != null) {
            return new QuotaCounterContractImpl(inner, this.manager());
        }
        return null;
    }

    private QuotaByPeriodKeysClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

