/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ResolverContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ResolverContract;
import com.azure.resourcemanager.apimanagement.models.ResolverUpdateContract;

public final class ResolverContractImpl
implements ResolverContract,
ResolverContract.Definition,
ResolverContract.Update {
    private ResolverContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String resolverId;
    private String createIfMatch;
    private String updateIfMatch;
    private ResolverUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String path() {
        return this.innerModel().path();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ResolverContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResolverContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public ResolverContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ResolverContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ResolverContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ResolverContractInner();
        this.serviceManager = serviceManager;
        this.resolverId = name;
        this.createIfMatch = null;
    }

    @Override
    public ResolverContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ResolverUpdateContract();
        return this;
    }

    @Override
    public ResolverContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ResolverContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().updateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    ResolverContractImpl(ResolverContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.resolverId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resolvers");
    }

    @Override
    public ResolverContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ResolverContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGraphQLApiResolvers().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.resolverId, context).getValue();
        return this;
    }

    @Override
    public ResolverContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public ResolverContractImpl withPath(String path) {
        if (this.isInCreateMode()) {
            this.innerModel().withPath(path);
            return this;
        }
        this.updateParameters.withPath(path);
        return this;
    }

    @Override
    public ResolverContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ResolverContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

