/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final ApiManagementClientImpl client;

    ResourceProvidersClientImpl(ApiManagementClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsyncWithResponseAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectivityCheckRequestParams == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectivityCheckRequestParams is required and cannot be null."));
        }
        connectivityCheckRequestParams.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.performConnectivityCheckAsync(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), connectivityCheckRequestParams, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsyncWithResponseAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectivityCheckRequestParams == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectivityCheckRequestParams is required and cannot be null."));
        }
        connectivityCheckRequestParams.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.performConnectivityCheckAsync(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), connectivityCheckRequestParams, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner> beginPerformConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.performConnectivityCheckAsyncWithResponseAsync(resourceGroupName, serviceName, connectivityCheckRequestParams);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConnectivityCheckResponseInner.class), (Type)((Object)ConnectivityCheckResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner> beginPerformConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.performConnectivityCheckAsyncWithResponseAsync(resourceGroupName, serviceName, connectivityCheckRequestParams, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConnectivityCheckResponseInner.class), (Type)((Object)ConnectivityCheckResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner> beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        return this.beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityCheckResponseInner>, ConnectivityCheckResponseInner> beginPerformConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return this.beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectivityCheckResponseInner> performConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        return this.beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectivityCheckResponseInner> performConnectivityCheckAsyncAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return this.beginPerformConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams) {
        return (ConnectivityCheckResponseInner)this.performConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectivityCheckResponseInner performConnectivityCheckAsync(String resourceGroupName, String serviceName, ConnectivityCheckRequest connectivityCheckRequestParams, Context context) {
        return (ConnectivityCheckResponseInner)this.performConnectivityCheckAsyncAsync(resourceGroupName, serviceName, connectivityCheckRequestParams, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientR")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/connectivityCheck")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> performConnectivityCheckAsync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") ConnectivityCheckRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

