/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.SignInSettingsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSigninSettingsInner;
import com.azure.resourcemanager.apimanagement.implementation.PortalSigninSettingsImpl;
import com.azure.resourcemanager.apimanagement.models.PortalSigninSettings;
import com.azure.resourcemanager.apimanagement.models.SignInSettings;
import com.azure.resourcemanager.apimanagement.models.SignInSettingsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.SignInSettingsGetResponse;

public final class SignInSettingsImpl
implements SignInSettings {
    private static final ClientLogger LOGGER = new ClientLogger(SignInSettingsImpl.class);
    private final SignInSettingsClient innerClient;
    private final ApiManagementManager serviceManager;

    public SignInSettingsImpl(SignInSettingsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public SignInSettingsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName);
    }

    @Override
    public Response<PortalSigninSettings> getWithResponse(String resourceGroupName, String serviceName, Context context) {
        SignInSettingsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalSigninSettingsImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PortalSigninSettings get(String resourceGroupName, String serviceName) {
        PortalSigninSettingsInner inner = this.serviceClient().get(resourceGroupName, serviceName);
        if (inner != null) {
            return new PortalSigninSettingsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> updateWithResponse(String resourceGroupName, String serviceName, String ifMatch, PortalSigninSettingsInner parameters, Context context) {
        return this.serviceClient().updateWithResponse(resourceGroupName, serviceName, ifMatch, parameters, context);
    }

    @Override
    public void update(String resourceGroupName, String serviceName, String ifMatch, PortalSigninSettingsInner parameters) {
        this.serviceClient().update(resourceGroupName, serviceName, ifMatch, parameters);
    }

    @Override
    public Response<PortalSigninSettings> createOrUpdateWithResponse(String resourceGroupName, String serviceName, PortalSigninSettingsInner parameters, String ifMatch, Context context) {
        Response<PortalSigninSettingsInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PortalSigninSettingsImpl((PortalSigninSettingsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PortalSigninSettings createOrUpdate(String resourceGroupName, String serviceName, PortalSigninSettingsInner parameters) {
        PortalSigninSettingsInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new PortalSigninSettingsImpl(inner, this.manager());
        }
        return null;
    }

    private SignInSettingsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

