/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TagApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagApiLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.TagApiLinks;
import com.azure.resourcemanager.apimanagement.models.TagApiLinksGetResponse;

public final class TagApiLinksImpl
implements TagApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(TagApiLinksImpl.class);
    private final TagApiLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public TagApiLinksImpl(TagApiLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId) {
        PagedIterable<TagApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagApiLinkContractImpl((TagApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagApiLinkContractImpl((TagApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagApiLinkContract> getWithResponse(String resourceGroupName, String serviceName, String tagId, String apiLinkId, Context context) {
        TagApiLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagApiLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagApiLinkContract get(String resourceGroupName, String serviceName, String tagId, String apiLinkId) {
        TagApiLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, tagId, apiLinkId);
        if (inner != null) {
            return new TagApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId, String apiLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String tagId, String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, apiLinkId);
    }

    @Override
    public TagApiLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return (TagApiLinkContract)this.getWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, Context.NONE).getValue();
    }

    @Override
    public Response<TagApiLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String apiLinkId = ResourceManagerUtils.getValueFromIdByName(id, "apiLinks");
        if (apiLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apiLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, apiLinkId, context);
    }

    private TagApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagApiLinkContractImpl define(String name) {
        return new TagApiLinkContractImpl(name, this.manager());
    }
}

