/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.TagContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.TagContract;
import com.azure.resourcemanager.apimanagement.models.TagCreateUpdateParameters;

public final class TagContractImpl
implements TagContract,
TagContract.Definition,
TagContract.Update {
    private TagContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String tagId;
    private String createIfMatch;
    private TagCreateUpdateParameters createParameters;
    private String updateIfMatch;
    private TagCreateUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TagContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public TagContract create() {
        this.innerObject = this.serviceManager.serviceClient().getTags().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.createParameters, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTags().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.createParameters, this.createIfMatch, context).getValue();
        return this;
    }

    TagContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new TagContractInner();
        this.serviceManager = serviceManager;
        this.tagId = name;
        this.createIfMatch = null;
        this.createParameters = new TagCreateUpdateParameters();
    }

    @Override
    public TagContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new TagCreateUpdateParameters();
        return this;
    }

    @Override
    public TagContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getTags().updateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTags().updateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    TagContractImpl(TagContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
    }

    @Override
    public TagContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getTags().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTags().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, context).getValue();
        return this;
    }

    @Override
    public TagContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.createParameters.withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public TagContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

