/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinkContract;

public final class TagOperationLinkContractImpl
implements TagOperationLinkContract,
TagOperationLinkContract.Definition,
TagOperationLinkContract.Update {
    private TagOperationLinkContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String tagId;
    private String operationLinkId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String operationId() {
        return this.innerModel().operationId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TagOperationLinkContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagOperationLinkContractImpl withExistingTag(String resourceGroupName, String serviceName, String tagId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.tagId = tagId;
        return this;
    }

    @Override
    public TagOperationLinkContract create() {
        this.innerObject = (TagOperationLinkContractInner)((Object)this.serviceManager.serviceClient().getTagOperationLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagOperationLinkContract create(Context context) {
        this.innerObject = (TagOperationLinkContractInner)((Object)this.serviceManager.serviceClient().getTagOperationLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagOperationLinkContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new TagOperationLinkContractInner();
        this.serviceManager = serviceManager;
        this.operationLinkId = name;
    }

    @Override
    public TagOperationLinkContractImpl update() {
        return this;
    }

    @Override
    public TagOperationLinkContract apply() {
        this.innerObject = (TagOperationLinkContractInner)((Object)this.serviceManager.serviceClient().getTagOperationLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public TagOperationLinkContract apply(Context context) {
        this.innerObject = (TagOperationLinkContractInner)((Object)this.serviceManager.serviceClient().getTagOperationLinks().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, this.innerModel(), context).getValue());
        return this;
    }

    TagOperationLinkContractImpl(TagOperationLinkContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.tagId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tags");
        this.operationLinkId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operationLinks");
    }

    @Override
    public TagOperationLinkContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getTagOperationLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagOperationLinkContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTagOperationLinks().getWithResponse(this.resourceGroupName, this.serviceName, this.tagId, this.operationLinkId, context).getValue();
        return this;
    }

    @Override
    public TagOperationLinkContractImpl withOperationId(String operationId) {
        this.innerModel().withOperationId(operationId);
        return this;
    }
}

