/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TagOperationLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagOperationLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinkContract;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinks;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinksGetResponse;

public final class TagOperationLinksImpl
implements TagOperationLinks {
    private static final ClientLogger LOGGER = new ClientLogger(TagOperationLinksImpl.class);
    private final TagOperationLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public TagOperationLinksImpl(TagOperationLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId) {
        PagedIterable<TagOperationLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl((TagOperationLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagOperationLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl((TagOperationLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagOperationLinkContract> getWithResponse(String resourceGroupName, String serviceName, String tagId, String operationLinkId, Context context) {
        TagOperationLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagOperationLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagOperationLinkContract get(String resourceGroupName, String serviceName, String tagId, String operationLinkId) {
        TagOperationLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, tagId, operationLinkId);
        if (inner != null) {
            return new TagOperationLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId, String operationLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String tagId, String operationLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, operationLinkId);
    }

    @Override
    public TagOperationLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return (TagOperationLinkContract)this.getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, Context.NONE).getValue();
    }

    @Override
    public Response<TagOperationLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String operationLinkId = ResourceManagerUtils.getValueFromIdByName(id, "operationLinks");
        if (operationLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operationLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, operationLinkId, context);
    }

    private TagOperationLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagOperationLinkContractImpl define(String name) {
        return new TagOperationLinkContractImpl(name, this.manager());
    }
}

