/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TagProductLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagProductLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagProductLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagProductLinkContract;
import com.azure.resourcemanager.apimanagement.models.TagProductLinks;
import com.azure.resourcemanager.apimanagement.models.TagProductLinksGetResponse;

public final class TagProductLinksImpl
implements TagProductLinks {
    private static final ClientLogger LOGGER = new ClientLogger(TagProductLinksImpl.class);
    private final TagProductLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public TagProductLinksImpl(TagProductLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId) {
        PagedIterable<TagProductLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl((TagProductLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagProductLinkContract> listByProduct(String resourceGroupName, String serviceName, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagProductLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagProductLinkContractImpl((TagProductLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagProductLinkContract> getWithResponse(String resourceGroupName, String serviceName, String tagId, String productLinkId, Context context) {
        TagProductLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagProductLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagProductLinkContract get(String resourceGroupName, String serviceName, String tagId, String productLinkId) {
        TagProductLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, tagId, productLinkId);
        if (inner != null) {
            return new TagProductLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId, String productLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String tagId, String productLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, productLinkId);
    }

    @Override
    public TagProductLinkContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return (TagProductLinkContract)this.getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, Context.NONE).getValue();
    }

    @Override
    public Response<TagProductLinkContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String productLinkId = ResourceManagerUtils.getValueFromIdByName(id, "productLinks");
        if (productLinkId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'productLinks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, productLinkId, context);
    }

    private TagProductLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagProductLinkContractImpl define(String name) {
        return new TagProductLinkContractImpl(name, this.manager());
    }
}

