/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TagsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagContract;
import com.azure.resourcemanager.apimanagement.models.Tags;
import com.azure.resourcemanager.apimanagement.models.TagsAssignToApiResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetByApiResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetByOperationResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetByProductResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetEntityStateByApiResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetEntityStateByOperationResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetEntityStateByProductResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetEntityStateResponse;
import com.azure.resourcemanager.apimanagement.models.TagsGetResponse;

public final class TagsImpl
implements Tags {
    private static final ClientLogger LOGGER = new ClientLogger(TagsImpl.class);
    private final TagsClient innerClient;
    private final ApiManagementManager serviceManager;

    public TagsImpl(TagsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagContract> listByOperation(String resourceGroupName, String serviceName, String apiId, String operationId) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, apiId, operationId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagContract> listByOperation(String resourceGroupName, String serviceName, String apiId, String operationId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, apiId, operationId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public TagsGetEntityStateByOperationResponse getEntityStateByOperationWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId, Context context) {
        return this.serviceClient().getEntityStateByOperationWithResponse(resourceGroupName, serviceName, apiId, operationId, tagId, context);
    }

    @Override
    public void getEntityStateByOperation(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId) {
        this.serviceClient().getEntityStateByOperation(resourceGroupName, serviceName, apiId, operationId, tagId);
    }

    @Override
    public Response<TagContract> getByOperationWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId, Context context) {
        TagsGetByOperationResponse inner = this.serviceClient().getByOperationWithResponse(resourceGroupName, serviceName, apiId, operationId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract getByOperation(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId) {
        TagContractInner inner = this.serviceClient().getByOperation(resourceGroupName, serviceName, apiId, operationId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagContract> assignToOperationWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId, Context context) {
        Response<TagContractInner> inner = this.serviceClient().assignToOperationWithResponse(resourceGroupName, serviceName, apiId, operationId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl((TagContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract assignToOperation(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId) {
        TagContractInner inner = this.serviceClient().assignToOperation(resourceGroupName, serviceName, apiId, operationId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> detachFromOperationWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId, Context context) {
        return this.serviceClient().detachFromOperationWithResponse(resourceGroupName, serviceName, apiId, operationId, tagId, context);
    }

    @Override
    public void detachFromOperation(String resourceGroupName, String serviceName, String apiId, String operationId, String tagId) {
        this.serviceClient().detachFromOperation(resourceGroupName, serviceName, apiId, operationId, tagId);
    }

    @Override
    public PagedIterable<TagContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagContract> listByApi(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public TagsGetEntityStateByApiResponse getEntityStateByApiWithResponse(String resourceGroupName, String serviceName, String apiId, String tagId, Context context) {
        return this.serviceClient().getEntityStateByApiWithResponse(resourceGroupName, serviceName, apiId, tagId, context);
    }

    @Override
    public void getEntityStateByApi(String resourceGroupName, String serviceName, String apiId, String tagId) {
        this.serviceClient().getEntityStateByApi(resourceGroupName, serviceName, apiId, tagId);
    }

    @Override
    public Response<TagContract> getByApiWithResponse(String resourceGroupName, String serviceName, String apiId, String tagId, Context context) {
        TagsGetByApiResponse inner = this.serviceClient().getByApiWithResponse(resourceGroupName, serviceName, apiId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract getByApi(String resourceGroupName, String serviceName, String apiId, String tagId) {
        TagContractInner inner = this.serviceClient().getByApi(resourceGroupName, serviceName, apiId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagContract> assignToApiWithResponse(String resourceGroupName, String serviceName, String apiId, String tagId, Context context) {
        TagsAssignToApiResponse inner = this.serviceClient().assignToApiWithResponse(resourceGroupName, serviceName, apiId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract assignToApi(String resourceGroupName, String serviceName, String apiId, String tagId) {
        TagContractInner inner = this.serviceClient().assignToApi(resourceGroupName, serviceName, apiId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> detachFromApiWithResponse(String resourceGroupName, String serviceName, String apiId, String tagId, Context context) {
        return this.serviceClient().detachFromApiWithResponse(resourceGroupName, serviceName, apiId, tagId, context);
    }

    @Override
    public void detachFromApi(String resourceGroupName, String serviceName, String apiId, String tagId) {
        this.serviceClient().detachFromApi(resourceGroupName, serviceName, apiId, tagId);
    }

    @Override
    public PagedIterable<TagContract> listByProduct(String resourceGroupName, String serviceName, String productId) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagContract> listByProduct(String resourceGroupName, String serviceName, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public TagsGetEntityStateByProductResponse getEntityStateByProductWithResponse(String resourceGroupName, String serviceName, String productId, String tagId, Context context) {
        return this.serviceClient().getEntityStateByProductWithResponse(resourceGroupName, serviceName, productId, tagId, context);
    }

    @Override
    public void getEntityStateByProduct(String resourceGroupName, String serviceName, String productId, String tagId) {
        this.serviceClient().getEntityStateByProduct(resourceGroupName, serviceName, productId, tagId);
    }

    @Override
    public Response<TagContract> getByProductWithResponse(String resourceGroupName, String serviceName, String productId, String tagId, Context context) {
        TagsGetByProductResponse inner = this.serviceClient().getByProductWithResponse(resourceGroupName, serviceName, productId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract getByProduct(String resourceGroupName, String serviceName, String productId, String tagId) {
        TagContractInner inner = this.serviceClient().getByProduct(resourceGroupName, serviceName, productId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagContract> assignToProductWithResponse(String resourceGroupName, String serviceName, String productId, String tagId, Context context) {
        Response<TagContractInner> inner = this.serviceClient().assignToProductWithResponse(resourceGroupName, serviceName, productId, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl((TagContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract assignToProduct(String resourceGroupName, String serviceName, String productId, String tagId) {
        TagContractInner inner = this.serviceClient().assignToProduct(resourceGroupName, serviceName, productId, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> detachFromProductWithResponse(String resourceGroupName, String serviceName, String productId, String tagId, Context context) {
        return this.serviceClient().detachFromProductWithResponse(resourceGroupName, serviceName, productId, tagId, context);
    }

    @Override
    public void detachFromProduct(String resourceGroupName, String serviceName, String productId, String tagId) {
        this.serviceClient().detachFromProduct(resourceGroupName, serviceName, productId, tagId);
    }

    @Override
    public PagedIterable<TagContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String scope, Context context) {
        PagedIterable<TagContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagContractImpl((TagContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public TagsGetEntityStateResponse getEntityStateWithResponse(String resourceGroupName, String serviceName, String tagId, Context context) {
        return this.serviceClient().getEntityStateWithResponse(resourceGroupName, serviceName, tagId, context);
    }

    @Override
    public void getEntityState(String resourceGroupName, String serviceName, String tagId) {
        this.serviceClient().getEntityState(resourceGroupName, serviceName, tagId);
    }

    @Override
    public Response<TagContract> getWithResponse(String resourceGroupName, String serviceName, String tagId, Context context) {
        TagsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, tagId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagContract get(String resourceGroupName, String serviceName, String tagId) {
        TagContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, tagId);
        if (inner != null) {
            return new TagContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String tagId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, tagId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String tagId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, tagId, ifMatch);
    }

    @Override
    public TagContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        return (TagContract)this.getWithResponse(resourceGroupName, serviceName, tagId, Context.NONE).getValue();
    }

    @Override
    public Response<TagContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, tagId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, tagId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String tagId = ResourceManagerUtils.getValueFromIdByName(id, "tags");
        if (tagId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tags'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, tagId, ifMatch, context);
    }

    private TagsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagContractImpl define(String name) {
        return new TagContractImpl(name, this.manager());
    }
}

