/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TenantAccessClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationSecretsContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AccessInformationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.AccessInformationSecretsContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.AccessInformationContract;
import com.azure.resourcemanager.apimanagement.models.AccessInformationSecretsContract;
import com.azure.resourcemanager.apimanagement.models.TenantAccess;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGetResponse;
import com.azure.resourcemanager.apimanagement.models.TenantAccessListSecretsResponse;

public final class TenantAccessImpl
implements TenantAccess {
    private static final ClientLogger LOGGER = new ClientLogger(TenantAccessImpl.class);
    private final TenantAccessClient innerClient;
    private final ApiManagementManager serviceManager;

    public TenantAccessImpl(TenantAccessClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AccessInformationContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AccessInformationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccessInformationContractImpl((AccessInformationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AccessInformationContract> listByService(String resourceGroupName, String serviceName, String filter, Context context) {
        PagedIterable<AccessInformationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccessInformationContractImpl((AccessInformationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public TenantAccessGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, accessName);
    }

    @Override
    public Response<AccessInformationContract> getWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        TenantAccessGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, accessName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AccessInformationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AccessInformationContract get(String resourceGroupName, String serviceName, AccessIdName accessName) {
        AccessInformationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, accessName);
        if (inner != null) {
            return new AccessInformationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return this.serviceClient().regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    @Override
    public void regeneratePrimaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regeneratePrimaryKey(resourceGroupName, serviceName, accessName);
    }

    @Override
    public Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return this.serviceClient().regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    @Override
    public void regenerateSecondaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regenerateSecondaryKey(resourceGroupName, serviceName, accessName);
    }

    @Override
    public Response<AccessInformationSecretsContract> listSecretsWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        TenantAccessListSecretsResponse inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, serviceName, accessName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AccessInformationSecretsContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AccessInformationSecretsContract listSecrets(String resourceGroupName, String serviceName, AccessIdName accessName) {
        AccessInformationSecretsContractInner inner = this.serviceClient().listSecrets(resourceGroupName, serviceName, accessName);
        if (inner != null) {
            return new AccessInformationSecretsContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AccessInformationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String accessNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "tenant");
        if (accessNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tenant'.", id)));
        }
        AccessIdName accessName = AccessIdName.fromString(accessNameLocal);
        return (AccessInformationContract)this.getWithResponse(resourceGroupName, serviceName, accessName, Context.NONE).getValue();
    }

    @Override
    public Response<AccessInformationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String accessNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "tenant");
        if (accessNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tenant'.", id)));
        }
        AccessIdName accessName = AccessIdName.fromString(accessNameLocal);
        return this.getWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    private TenantAccessClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccessInformationContractImpl define(AccessIdName name) {
        return new AccessInformationContractImpl(name, this.manager());
    }
}

