/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TenantConfigurationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner;
import com.azure.resourcemanager.apimanagement.implementation.OperationResultContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.TenantConfigurationSyncStateContractImpl;
import com.azure.resourcemanager.apimanagement.models.ConfigurationIdName;
import com.azure.resourcemanager.apimanagement.models.DeployConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.OperationResultContract;
import com.azure.resourcemanager.apimanagement.models.SaveConfigurationParameter;
import com.azure.resourcemanager.apimanagement.models.TenantConfigurationSyncStateContract;
import com.azure.resourcemanager.apimanagement.models.TenantConfigurations;

public final class TenantConfigurationsImpl
implements TenantConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(TenantConfigurationsImpl.class);
    private final TenantConfigurationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public TenantConfigurationsImpl(TenantConfigurationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public OperationResultContract deploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        OperationResultContractInner inner = this.serviceClient().deploy(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract deploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        OperationResultContractInner inner = this.serviceClient().deploy(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract save(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        OperationResultContractInner inner = this.serviceClient().save(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract save(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        OperationResultContractInner inner = this.serviceClient().save(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract validate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        OperationResultContractInner inner = this.serviceClient().validate(resourceGroupName, serviceName, configurationName, parameters);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultContract validate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        OperationResultContractInner inner = this.serviceClient().validate(resourceGroupName, serviceName, configurationName, parameters, context);
        if (inner != null) {
            return new OperationResultContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TenantConfigurationSyncStateContract> getSyncStateWithResponse(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, Context context) {
        Response<TenantConfigurationSyncStateContractInner> inner = this.serviceClient().getSyncStateWithResponse(resourceGroupName, serviceName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TenantConfigurationSyncStateContractImpl((TenantConfigurationSyncStateContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TenantConfigurationSyncStateContract getSyncState(String resourceGroupName, String serviceName, ConfigurationIdName configurationName) {
        TenantConfigurationSyncStateContractInner inner = this.serviceClient().getSyncState(resourceGroupName, serviceName, configurationName);
        if (inner != null) {
            return new TenantConfigurationSyncStateContractImpl(inner, this.manager());
        }
        return null;
    }

    private TenantConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

