/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.UserGroupsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractInner;
import com.azure.resourcemanager.apimanagement.implementation.GroupContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GroupContract;
import com.azure.resourcemanager.apimanagement.models.UserGroups;

public final class UserGroupsImpl
implements UserGroups {
    private static final ClientLogger LOGGER = new ClientLogger(UserGroupsImpl.class);
    private final UserGroupsClient innerClient;
    private final ApiManagementManager serviceManager;

    public UserGroupsImpl(UserGroupsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GroupContract> list(String resourceGroupName, String serviceName, String userId) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GroupContract> list(String resourceGroupName, String serviceName, String userId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    private UserGroupsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

