/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.UserSubscriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.SubscriptionContractImpl;
import com.azure.resourcemanager.apimanagement.models.SubscriptionContract;
import com.azure.resourcemanager.apimanagement.models.UserSubscriptions;
import com.azure.resourcemanager.apimanagement.models.UserSubscriptionsGetResponse;

public final class UserSubscriptionsImpl
implements UserSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(UserSubscriptionsImpl.class);
    private final UserSubscriptionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public UserSubscriptionsImpl(UserSubscriptionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String userId) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String userId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, userId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SubscriptionContract> getWithResponse(String resourceGroupName, String serviceName, String userId, String sid, Context context) {
        UserSubscriptionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, userId, sid, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionContract get(String resourceGroupName, String serviceName, String userId, String sid) {
        SubscriptionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, userId, sid);
        if (inner != null) {
            return new SubscriptionContractImpl(inner, this.manager());
        }
        return null;
    }

    private UserSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

