/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.UsersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GenerateSsoUrlResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.UserTokenResultInner;
import com.azure.resourcemanager.apimanagement.implementation.GenerateSsoUrlResultImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.UserContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.UserTokenResultImpl;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.GenerateSsoUrlResult;
import com.azure.resourcemanager.apimanagement.models.UserContract;
import com.azure.resourcemanager.apimanagement.models.UserTokenParameters;
import com.azure.resourcemanager.apimanagement.models.UserTokenResult;
import com.azure.resourcemanager.apimanagement.models.Users;
import com.azure.resourcemanager.apimanagement.models.UsersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.UsersGetResponse;

public final class UsersImpl
implements Users {
    private static final ClientLogger LOGGER = new ClientLogger(UsersImpl.class);
    private final UsersClient innerClient;
    private final ApiManagementManager serviceManager;

    public UsersImpl(UsersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UserContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<UserContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl((UserContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<UserContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean expandGroups, Context context) {
        PagedIterable<UserContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, expandGroups, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl((UserContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public UsersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String userId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, userId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String userId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, userId);
    }

    @Override
    public Response<UserContract> getWithResponse(String resourceGroupName, String serviceName, String userId, Context context) {
        UsersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, userId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UserContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UserContract get(String resourceGroupName, String serviceName, String userId) {
        UserContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, userId);
        if (inner != null) {
            return new UserContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String userId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, userId, ifMatch);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String userId, String ifMatch, Boolean deleteSubscriptions, Boolean notify, AppType appType, Context context) {
        this.serviceClient().delete(resourceGroupName, serviceName, userId, ifMatch, deleteSubscriptions, notify, appType, context);
    }

    @Override
    public Response<GenerateSsoUrlResult> generateSsoUrlWithResponse(String resourceGroupName, String serviceName, String userId, Context context) {
        Response<GenerateSsoUrlResultInner> inner = this.serviceClient().generateSsoUrlWithResponse(resourceGroupName, serviceName, userId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GenerateSsoUrlResultImpl((GenerateSsoUrlResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GenerateSsoUrlResult generateSsoUrl(String resourceGroupName, String serviceName, String userId) {
        GenerateSsoUrlResultInner inner = this.serviceClient().generateSsoUrl(resourceGroupName, serviceName, userId);
        if (inner != null) {
            return new GenerateSsoUrlResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<UserTokenResult> getSharedAccessTokenWithResponse(String resourceGroupName, String serviceName, String userId, UserTokenParameters parameters, Context context) {
        Response<UserTokenResultInner> inner = this.serviceClient().getSharedAccessTokenWithResponse(resourceGroupName, serviceName, userId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UserTokenResultImpl((UserTokenResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UserTokenResult getSharedAccessToken(String resourceGroupName, String serviceName, String userId, UserTokenParameters parameters) {
        UserTokenResultInner inner = this.serviceClient().getSharedAccessToken(resourceGroupName, serviceName, userId, parameters);
        if (inner != null) {
            return new UserTokenResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UserContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String userId = ResourceManagerUtils.getValueFromIdByName(id, "users");
        if (userId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'users'.", id)));
        }
        return (UserContract)this.getWithResponse(resourceGroupName, serviceName, userId, Context.NONE).getValue();
    }

    @Override
    public Response<UserContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String userId = ResourceManagerUtils.getValueFromIdByName(id, "users");
        if (userId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'users'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, userId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String userId = ResourceManagerUtils.getValueFromIdByName(id, "users");
        if (userId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'users'.", id)));
        }
        String localIfMatch = null;
        Boolean localDeleteSubscriptions = null;
        Boolean localNotify = null;
        AppType localAppType = null;
        this.delete(resourceGroupName, serviceName, userId, localIfMatch, localDeleteSubscriptions, localNotify, localAppType, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Boolean deleteSubscriptions, Boolean notify, AppType appType, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String userId = ResourceManagerUtils.getValueFromIdByName(id, "users");
        if (userId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'users'.", id)));
        }
        this.delete(resourceGroupName, serviceName, userId, ifMatch, deleteSubscriptions, notify, appType, context);
    }

    private UsersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public UserContractImpl define(String name) {
        return new UserContractImpl(name, this.manager());
    }
}

