/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiExportsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiExportResultInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiExportResultImpl;
import com.azure.resourcemanager.apimanagement.models.ApiExportResult;
import com.azure.resourcemanager.apimanagement.models.ExportApi;
import com.azure.resourcemanager.apimanagement.models.ExportFormat;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiExports;

public final class WorkspaceApiExportsImpl
implements WorkspaceApiExports {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiExportsImpl.class);
    private final WorkspaceApiExportsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceApiExportsImpl(WorkspaceApiExportsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ApiExportResult> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, ExportFormat format, ExportApi export, Context context) {
        Response<ApiExportResultInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, format, export, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiExportResultImpl((ApiExportResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiExportResult get(String resourceGroupName, String serviceName, String workspaceId, String apiId, ExportFormat format, ExportApi export) {
        ApiExportResultInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, format, export);
        if (inner != null) {
            return new ApiExportResultImpl(inner, this.manager());
        }
        return null;
    }

    private WorkspaceApiExportsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

