/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiOperationPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationPoliciesGetResponse;

public final class WorkspaceApiOperationPoliciesImpl
implements WorkspaceApiOperationPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiOperationPoliciesImpl.class);
    private final WorkspaceApiOperationPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceApiOperationPoliciesImpl(WorkspaceApiOperationPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyContract> listByOperation(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, workspaceId, apiId, operationId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyContract> listByOperation(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, Context context) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, workspaceId, apiId, operationId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceApiOperationPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        WorkspaceApiOperationPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        WorkspaceApiOperationPoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, operationId, policyId, ifMatch);
    }

    private WorkspaceApiOperationPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

