/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApiOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.OperationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.OperationContract;
import com.azure.resourcemanager.apimanagement.models.OperationUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperations;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApiOperationsUpdateResponse;

public final class WorkspaceApiOperationsImpl
implements WorkspaceApiOperations {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApiOperationsImpl.class);
    private final WorkspaceApiOperationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceApiOperationsImpl(WorkspaceApiOperationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        PagedIterable<OperationContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl((OperationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String workspaceId, String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        PagedIterable<OperationContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, apiId, filter, top, skip, tags, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl((OperationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceApiOperationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId, operationId);
    }

    @Override
    public Response<OperationContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, Context context) {
        WorkspaceApiOperationsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId) {
        OperationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId, operationId);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<OperationContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, OperationContractInner parameters, String ifMatch, Context context) {
        WorkspaceApiOperationsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, OperationContractInner parameters) {
        OperationContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, operationId, parameters);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<OperationContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters, Context context) {
        WorkspaceApiOperationsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationContract update(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, String ifMatch, OperationUpdateContract parameters) {
        OperationContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, parameters);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String operationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, operationId, ifMatch);
    }

    private WorkspaceApiOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

