/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ApiCollection;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdateParameter;
import com.azure.resourcemanager.apimanagement.models.ApiUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisUpdateResponse;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WorkspaceApisClientImpl
implements WorkspaceApisClient {
    private final WorkspaceApisService service;
    private final ApiManagementClientImpl client;

    WorkspaceApisClientImpl(ApiManagementClientImpl client) {
        this.service = (WorkspaceApisService)RestProxy.create(WorkspaceApisService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiCollection)res.getValue()).value(), ((ApiCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiCollection)res.getValue()).value(), ((ApiCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String workspaceId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String tags = null;
        Boolean expandApiVersionSet = null;
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiContractInner> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String tags = null;
        Boolean expandApiVersionSet = null;
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiContractInner> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceApisGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        return (WorkspaceApisGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiContractInner> getAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceApisGetResponse getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        return (WorkspaceApisGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiContractInner get(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        return this.getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiContractInner>, ApiContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApiContractInner.class), (Type)((Object)ApiContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiContractInner>, ApiContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApiContractInner.class), (Type)((Object)ApiContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiContractInner>, ApiContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApiContractInner.class), (Type)((Object)ApiContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiContractInner>, ApiContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiContractInner>, ApiContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiContractInner createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters) {
        String ifMatch = null;
        return (ApiContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiContractInner createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        return (ApiContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceApisUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiContractInner> updateAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters) {
        return this.updateWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceApisUpdateResponse updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters, Context context) {
        return (WorkspaceApisUpdateResponse)((Object)this.updateWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiContractInner update(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters) {
        return this.updateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, Boolean deleteRevisions) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, deleteRevisions, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, Boolean deleteRevisions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, apiId, deleteRevisions, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch) {
        Boolean deleteRevisions = null;
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, deleteRevisions).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, Boolean deleteRevisions, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, deleteRevisions, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch) {
        Boolean deleteRevisions = null;
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, deleteRevisions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiContractInner>> listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiCollection)res.getValue()).value(), ((ApiCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiContractInner>> listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiCollection)res.getValue()).value(), ((ApiCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientW")
    public static interface WorkspaceApisService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiCollection>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skip") Integer var7, @QueryParam(value="tags") String var8, @QueryParam(value="expandApiVersionSet") Boolean var9, @QueryParam(value="api-version") String var10, @PathParam(value="subscriptionId") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceApisGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="apiId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceApisGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="apiId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="apiId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") ApiCreateOrUpdateParameter var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceApisUpdateResponse> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="apiId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") ApiUpdateContract var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="apiId") String var5, @QueryParam(value="deleteRevisions") Boolean var6, @HeaderParam(value="If-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiCollection>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

