/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceApisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdateParameter;
import com.azure.resourcemanager.apimanagement.models.ApiUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApis;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceApisUpdateResponse;

public final class WorkspaceApisImpl
implements WorkspaceApis {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceApisImpl.class);
    private final WorkspaceApisClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceApisImpl(WorkspaceApisClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiContract> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiContract> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet, Context context) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, tags, expandApiVersionSet, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceApisGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, apiId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, apiId);
    }

    @Override
    public Response<ApiContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, Context context) {
        WorkspaceApisGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, apiId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiContract get(String resourceGroupName, String serviceName, String workspaceId, String apiId) {
        ApiContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, apiId);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters) {
        ApiContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, parameters);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String apiId, ApiCreateOrUpdateParameter parameters, String ifMatch, Context context) {
        ApiContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, apiId, parameters, ifMatch, context);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters, Context context) {
        WorkspaceApisUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiContract update(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, ApiUpdateContract parameters) {
        ApiContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, parameters);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch, Boolean deleteRevisions, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, apiId, ifMatch, deleteRevisions, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String apiId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, apiId, ifMatch);
    }

    private WorkspaceApisClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

