/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.WorkspaceContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.WorkspaceContract;

public final class WorkspaceContractImpl
implements WorkspaceContract,
WorkspaceContract.Definition,
WorkspaceContract.Update {
    private WorkspaceContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkspaceContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public WorkspaceContract create() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public WorkspaceContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    WorkspaceContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new WorkspaceContractInner();
        this.serviceManager = serviceManager;
        this.workspaceId = name;
        this.createIfMatch = null;
    }

    @Override
    public WorkspaceContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public WorkspaceContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, this.updateIfMatch, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public WorkspaceContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, this.updateIfMatch, this.innerModel(), context).getValue();
        return this;
    }

    WorkspaceContractImpl(WorkspaceContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.workspaceId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
    }

    @Override
    public WorkspaceContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, Context.NONE).getValue();
        return this;
    }

    @Override
    public WorkspaceContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceId, context).getValue();
        return this;
    }

    @Override
    public WorkspaceContractImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public WorkspaceContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public WorkspaceContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

