/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceDiagnosticsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.DiagnosticCollection;
import com.azure.resourcemanager.apimanagement.models.DiagnosticUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceDiagnosticsUpdateResponse;
import reactor.core.publisher.Mono;

public final class WorkspaceDiagnosticsClientImpl
implements WorkspaceDiagnosticsClient {
    private final WorkspaceDiagnosticsService service;
    private final ApiManagementClientImpl client;

    WorkspaceDiagnosticsClientImpl(ApiManagementClientImpl client) {
        this.service = (WorkspaceDiagnosticsService)RestProxy.create(WorkspaceDiagnosticsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticContractInner>> listByWorkspaceSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspace(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiagnosticCollection)res.getValue()).value(), ((DiagnosticCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticContractInner>> listByWorkspaceSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByWorkspace(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiagnosticCollection)res.getValue()).value(), ((DiagnosticCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiagnosticContractInner> listByWorkspaceAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiagnosticContractInner> listByWorkspaceAsync(String resourceGroupName, String serviceName, String workspaceId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiagnosticContractInner> listByWorkspaceAsync(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, context), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiagnosticContractInner> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listByWorkspaceAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiagnosticContractInner> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listByWorkspaceAsync(resourceGroupName, serviceName, workspaceId, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceDiagnosticsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        return (WorkspaceDiagnosticsGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiagnosticContractInner> getAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceDiagnosticsGetResponse getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, Context context) {
        return (WorkspaceDiagnosticsGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticContractInner get(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId) {
        return this.getWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiagnosticContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceDiagnosticsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters, String ifMatch, Context context) {
        return (WorkspaceDiagnosticsCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticContractInner createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, DiagnosticContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, parameters, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceDiagnosticsUpdateResponse> updateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiagnosticContractInner> updateAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters) {
        return this.updateWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceDiagnosticsUpdateResponse updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters, Context context) {
        return (WorkspaceDiagnosticsUpdateResponse)((Object)this.updateWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticContractInner update(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, DiagnosticUpdateContract parameters) {
        return this.updateWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (diagnosticId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String diagnosticId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceId, diagnosticId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticContractInner>> listByWorkspaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiagnosticCollection)res.getValue()).value(), ((DiagnosticCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticContractInner>> listByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiagnosticCollection)res.getValue()).value(), ((DiagnosticCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientW")
    public static interface WorkspaceDiagnosticsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiagnosticCollection>> listByWorkspace(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skip") Integer var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics/{diagnosticId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceDiagnosticsGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="diagnosticId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics/{diagnosticId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceDiagnosticsGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="diagnosticId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics/{diagnosticId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceDiagnosticsCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="diagnosticId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") DiagnosticContractInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics/{diagnosticId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceDiagnosticsUpdateResponse> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="diagnosticId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") DiagnosticUpdateContract var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/diagnostics/{diagnosticId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="diagnosticId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiagnosticCollection>> listByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

