/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceGroupsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractInner;
import com.azure.resourcemanager.apimanagement.implementation.GroupContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GroupContract;
import com.azure.resourcemanager.apimanagement.models.GroupCreateParameters;
import com.azure.resourcemanager.apimanagement.models.GroupUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroups;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsUpdateResponse;

public final class WorkspaceGroupsImpl
implements WorkspaceGroups {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceGroupsImpl.class);
    private final WorkspaceGroupsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceGroupsImpl(WorkspaceGroupsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceGroupsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String groupId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, groupId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String groupId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, groupId);
    }

    @Override
    public Response<GroupContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String groupId, Context context) {
        WorkspaceGroupsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, groupId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GroupContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GroupContract get(String resourceGroupName, String serviceName, String workspaceId, String groupId) {
        GroupContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, groupId);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<GroupContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String groupId, GroupCreateParameters parameters, String ifMatch, Context context) {
        WorkspaceGroupsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, groupId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GroupContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GroupContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String groupId, GroupCreateParameters parameters) {
        GroupContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, groupId, parameters);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<GroupContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String groupId, String ifMatch, GroupUpdateParameters parameters, Context context) {
        WorkspaceGroupsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GroupContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GroupContract update(String resourceGroupName, String serviceName, String workspaceId, String groupId, String ifMatch, GroupUpdateParameters parameters) {
        GroupContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, parameters);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String groupId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String groupId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, groupId, ifMatch);
    }

    private WorkspaceGroupsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

