/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceLoggersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.LoggerContractInner;
import com.azure.resourcemanager.apimanagement.implementation.LoggerContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.LoggerContract;
import com.azure.resourcemanager.apimanagement.models.LoggerUpdateContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggers;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggersCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggersGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLoggersUpdateResponse;

public final class WorkspaceLoggersImpl
implements WorkspaceLoggers {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceLoggersImpl.class);
    private final WorkspaceLoggersClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceLoggersImpl(WorkspaceLoggersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LoggerContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<LoggerContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LoggerContractImpl((LoggerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LoggerContract> listByWorkspace(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<LoggerContractInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LoggerContractImpl((LoggerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceLoggersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String loggerId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, loggerId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String loggerId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, loggerId);
    }

    @Override
    public Response<LoggerContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String loggerId, Context context) {
        WorkspaceLoggersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, loggerId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LoggerContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LoggerContract get(String resourceGroupName, String serviceName, String workspaceId, String loggerId) {
        LoggerContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, loggerId);
        if (inner != null) {
            return new LoggerContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<LoggerContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String loggerId, LoggerContractInner parameters, String ifMatch, Context context) {
        WorkspaceLoggersCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, loggerId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LoggerContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LoggerContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String loggerId, LoggerContractInner parameters) {
        LoggerContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, loggerId, parameters);
        if (inner != null) {
            return new LoggerContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<LoggerContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String loggerId, String ifMatch, LoggerUpdateContract parameters, Context context) {
        WorkspaceLoggersUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, loggerId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LoggerContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LoggerContract update(String resourceGroupName, String serviceName, String workspaceId, String loggerId, String ifMatch, LoggerUpdateContract parameters) {
        LoggerContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, loggerId, ifMatch, parameters);
        if (inner != null) {
            return new LoggerContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String loggerId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, loggerId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String loggerId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, loggerId, ifMatch);
    }

    private WorkspaceLoggersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

