/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspacePoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import com.azure.resourcemanager.apimanagement.models.WorkspacePolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspacePoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspacePoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspacePoliciesGetResponse;

public final class WorkspacePoliciesImpl
implements WorkspacePolicies {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacePoliciesImpl.class);
    private final WorkspacePoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspacePoliciesImpl(WorkspacePoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyContract> listByApi(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyContract> listByApi(String resourceGroupName, String serviceName, String workspaceId, Context context) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, workspaceId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspacePoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        WorkspacePoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        WorkspacePoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, policyId, ifMatch);
    }

    private WorkspacePoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

