/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkCollection;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinksGetResponse;
import reactor.core.publisher.Mono;

public final class WorkspaceProductApiLinksClientImpl
implements WorkspaceProductApiLinksClient {
    private final WorkspaceProductApiLinksService service;
    private final ApiManagementClientImpl client;

    WorkspaceProductApiLinksClientImpl(ApiManagementClientImpl client) {
        this.service = (WorkspaceProductApiLinksService)RestProxy.create(WorkspaceProductApiLinksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProductApiLinkContractInner>> listByProductSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProduct(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProductApiLinkCollection)res.getValue()).value(), ((ProductApiLinkCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProductApiLinkContractInner>> listByProductSinglePageAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProduct(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProductApiLinkCollection)res.getValue()).value(), ((ProductApiLinkCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProductApiLinkContractInner> listByProductAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listByProductSinglePageAsync(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip), nextLink -> this.listByProductNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProductApiLinkContractInner> listByProductAsync(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listByProductSinglePageAsync(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip), nextLink -> this.listByProductNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProductApiLinkContractInner> listByProductAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByProductSinglePageAsync(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context), nextLink -> this.listByProductNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProductApiLinkContractInner> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listByProductAsync(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProductApiLinkContractInner> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listByProductAsync(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceProductApiLinksGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspaceProductApiLinksGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ProductApiLinkContractInner> getAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspaceProductApiLinksGetResponse getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        return (WorkspaceProductApiLinksGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProductApiLinkContractInner get(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        return this.getWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProductApiLinkContractInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProductApiLinkContractInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ProductApiLinkContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ProductApiLinkContractInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProductApiLinkContractInner> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProductApiLinkContractInner createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters) {
        return (ProductApiLinkContractInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (productId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter productId is required and cannot be null."));
        }
        if (apiLinkId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiLinkId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, workspaceId, productId, apiLinkId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId, String apiLinkId) {
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProductApiLinkContractInner>> listByProductNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProductNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProductApiLinkCollection)res.getValue()).value(), ((ProductApiLinkCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProductApiLinkContractInner>> listByProductNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProductNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProductApiLinkCollection)res.getValue()).value(), ((ProductApiLinkCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientW")
    public static interface WorkspaceProductApiLinksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/apiLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProductApiLinkCollection>> listByProduct(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="productId") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$skip") Integer var8, @QueryParam(value="api-version") String var9, @PathParam(value="subscriptionId") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/apiLinks/{apiLinkId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspaceProductApiLinksGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="productId") String var5, @PathParam(value="apiLinkId") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/apiLinks/{apiLinkId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProductApiLinkContractInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="productId") String var5, @PathParam(value="apiLinkId") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") ProductApiLinkContractInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/apiLinks/{apiLinkId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="workspaceId") String var4, @PathParam(value="productId") String var5, @PathParam(value="apiLinkId") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProductApiLinkCollection>> listByProductNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

