/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyCollectionImpl;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.models.PolicyCollection;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductPolicies;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductPoliciesGetResponse;

public final class WorkspaceProductPoliciesImpl
implements WorkspaceProductPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductPoliciesImpl.class);
    private final WorkspaceProductPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceProductPoliciesImpl(WorkspaceProductPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PolicyCollection> listByProductWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, Context context) {
        Response<PolicyCollectionInner> inner = this.serviceClient().listByProductWithResponse(resourceGroupName, serviceName, workspaceId, productId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyCollectionImpl((PolicyCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyCollection listByProduct(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        PolicyCollectionInner inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId);
        if (inner != null) {
            return new PolicyCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public WorkspaceProductPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, productId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, productId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        WorkspaceProductPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, productId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        WorkspaceProductPoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, policyId, ifMatch);
    }

    private WorkspaceProductPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

