/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceSubscriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionKeysContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.SubscriptionContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.SubscriptionKeysContractImpl;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionContract;
import com.azure.resourcemanager.apimanagement.models.SubscriptionCreateParameters;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeysContract;
import com.azure.resourcemanager.apimanagement.models.SubscriptionUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptions;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptionsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptionsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptionsListSecretsResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceSubscriptionsUpdateResponse;

public final class WorkspaceSubscriptionsImpl
implements WorkspaceSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceSubscriptionsImpl.class);
    private final WorkspaceSubscriptionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceSubscriptionsImpl(WorkspaceSubscriptionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String workspaceId) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubscriptionContract> list(String resourceGroupName, String serviceName, String workspaceId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SubscriptionContractInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionContractImpl((SubscriptionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkspaceSubscriptionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, sid, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String sid) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, sid);
    }

    @Override
    public Response<SubscriptionContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, Context context) {
        WorkspaceSubscriptionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, sid, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionContract get(String resourceGroupName, String serviceName, String workspaceId, String sid) {
        SubscriptionContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, sid);
        if (inner != null) {
            return new SubscriptionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SubscriptionContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, SubscriptionCreateParameters parameters, Boolean notify, String ifMatch, AppType appType, Context context) {
        WorkspaceSubscriptionsCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, sid, parameters, notify, ifMatch, appType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String sid, SubscriptionCreateParameters parameters) {
        SubscriptionContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, sid, parameters);
        if (inner != null) {
            return new SubscriptionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SubscriptionContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, String ifMatch, SubscriptionUpdateParameters parameters, Boolean notify, AppType appType, Context context) {
        WorkspaceSubscriptionsUpdateResponse inner = this.serviceClient().updateWithResponse(resourceGroupName, serviceName, workspaceId, sid, ifMatch, parameters, notify, appType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionContract update(String resourceGroupName, String serviceName, String workspaceId, String sid, String ifMatch, SubscriptionUpdateParameters parameters) {
        SubscriptionContractInner inner = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, sid, ifMatch, parameters);
        if (inner != null) {
            return new SubscriptionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, sid, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String sid, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, sid, ifMatch);
    }

    @Override
    public Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, Context context) {
        return this.serviceClient().regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, workspaceId, sid, context);
    }

    @Override
    public void regeneratePrimaryKey(String resourceGroupName, String serviceName, String workspaceId, String sid) {
        this.serviceClient().regeneratePrimaryKey(resourceGroupName, serviceName, workspaceId, sid);
    }

    @Override
    public Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, Context context) {
        return this.serviceClient().regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, workspaceId, sid, context);
    }

    @Override
    public void regenerateSecondaryKey(String resourceGroupName, String serviceName, String workspaceId, String sid) {
        this.serviceClient().regenerateSecondaryKey(resourceGroupName, serviceName, workspaceId, sid);
    }

    @Override
    public Response<SubscriptionKeysContract> listSecretsWithResponse(String resourceGroupName, String serviceName, String workspaceId, String sid, Context context) {
        WorkspaceSubscriptionsListSecretsResponse inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, serviceName, workspaceId, sid, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionKeysContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionKeysContract listSecrets(String resourceGroupName, String serviceName, String workspaceId, String sid) {
        SubscriptionKeysContractInner inner = this.serviceClient().listSecrets(resourceGroupName, serviceName, workspaceId, sid);
        if (inner != null) {
            return new SubscriptionKeysContractImpl(inner, this.manager());
        }
        return null;
    }

    private WorkspaceSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

