/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceTagApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagApiLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagApiLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagApiLinksGetResponse;

public final class WorkspaceTagApiLinksImpl
implements WorkspaceTagApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceTagApiLinksImpl.class);
    private final WorkspaceTagApiLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceTagApiLinksImpl(WorkspaceTagApiLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId) {
        PagedIterable<TagApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagApiLinkContractImpl((TagApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagApiLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagApiLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagApiLinkContractImpl((TagApiLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagApiLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId, Context context) {
        WorkspaceTagApiLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagApiLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagApiLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId) {
        TagApiLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId);
        if (inner != null) {
            return new TagApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagApiLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId, TagApiLinkContractInner parameters, Context context) {
        Response<TagApiLinkContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagApiLinkContractImpl((TagApiLinkContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TagApiLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId, TagApiLinkContractInner parameters) {
        TagApiLinkContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId, parameters);
        if (inner != null) {
            return new TagApiLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String tagId, String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, tagId, apiLinkId);
    }

    private WorkspaceTagApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

