/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceTagOperationLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagOperationLinkContractImpl;
import com.azure.resourcemanager.apimanagement.models.TagOperationLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagOperationLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceTagOperationLinksGetResponse;

public final class WorkspaceTagOperationLinksImpl
implements WorkspaceTagOperationLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceTagOperationLinksImpl.class);
    private final WorkspaceTagOperationLinksClient innerClient;
    private final ApiManagementManager serviceManager;

    public WorkspaceTagOperationLinksImpl(WorkspaceTagOperationLinksClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId) {
        PagedIterable<TagOperationLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl((TagOperationLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TagOperationLinkContract> listByProduct(String resourceGroupName, String serviceName, String workspaceId, String tagId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagOperationLinkContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, tagId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagOperationLinkContractImpl((TagOperationLinkContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TagOperationLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId, Context context) {
        WorkspaceTagOperationLinksGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagOperationLinkContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TagOperationLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId) {
        TagOperationLinkContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId);
        if (inner != null) {
            return new TagOperationLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TagOperationLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId, TagOperationLinkContractInner parameters, Context context) {
        Response<TagOperationLinkContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TagOperationLinkContractImpl((TagOperationLinkContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TagOperationLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId, TagOperationLinkContractInner parameters) {
        TagOperationLinkContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId, parameters);
        if (inner != null) {
            return new TagOperationLinkContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceId, String tagId, String operationLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, tagId, operationLinkId);
    }

    private WorkspaceTagOperationLinksClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

