/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class AdditionalLocation
implements JsonSerializable<AdditionalLocation> {
    private String location;
    private ApiManagementServiceSkuProperties sku;
    private List<String> zones;
    private List<String> publicIpAddresses;
    private List<String> privateIpAddresses;
    private String publicIpAddressId;
    private VirtualNetworkConfiguration virtualNetworkConfiguration;
    private String gatewayRegionalUrl;
    private NatGatewayState natGatewayState;
    private List<String> outboundPublicIpAddresses;
    private Boolean disableGateway;
    private PlatformVersion platformVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AdditionalLocation.class);

    public String location() {
        return this.location;
    }

    public AdditionalLocation withLocation(String location) {
        this.location = location;
        return this;
    }

    public ApiManagementServiceSkuProperties sku() {
        return this.sku;
    }

    public AdditionalLocation withSku(ApiManagementServiceSkuProperties sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public AdditionalLocation withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public String publicIpAddressId() {
        return this.publicIpAddressId;
    }

    public AdditionalLocation withPublicIpAddressId(String publicIpAddressId) {
        this.publicIpAddressId = publicIpAddressId;
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.virtualNetworkConfiguration;
    }

    public AdditionalLocation withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        this.virtualNetworkConfiguration = virtualNetworkConfiguration;
        return this;
    }

    public String gatewayRegionalUrl() {
        return this.gatewayRegionalUrl;
    }

    public NatGatewayState natGatewayState() {
        return this.natGatewayState;
    }

    public AdditionalLocation withNatGatewayState(NatGatewayState natGatewayState) {
        this.natGatewayState = natGatewayState;
        return this;
    }

    public List<String> outboundPublicIpAddresses() {
        return this.outboundPublicIpAddresses;
    }

    public Boolean disableGateway() {
        return this.disableGateway;
    }

    public AdditionalLocation withDisableGateway(Boolean disableGateway) {
        this.disableGateway = disableGateway;
        return this;
    }

    public PlatformVersion platformVersion() {
        return this.platformVersion;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model AdditionalLocation"));
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model AdditionalLocation"));
        }
        this.sku().validate();
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("publicIpAddressId", this.publicIpAddressId);
        jsonWriter.writeJsonField("virtualNetworkConfiguration", (JsonSerializable)this.virtualNetworkConfiguration);
        jsonWriter.writeStringField("natGatewayState", this.natGatewayState == null ? null : this.natGatewayState.toString());
        jsonWriter.writeBooleanField("disableGateway", this.disableGateway);
        return jsonWriter.writeEndObject();
    }

    public static AdditionalLocation fromJson(JsonReader jsonReader) throws IOException {
        return (AdditionalLocation)jsonReader.readObject(reader -> {
            AdditionalLocation deserializedAdditionalLocation = new AdditionalLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedAdditionalLocation.location = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAdditionalLocation.sku = ApiManagementServiceSkuProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedAdditionalLocation.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIPAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedAdditionalLocation.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateIPAddresses".equals(fieldName)) {
                    List privateIpAddresses;
                    deserializedAdditionalLocation.privateIpAddresses = privateIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIpAddressId".equals(fieldName)) {
                    deserializedAdditionalLocation.publicIpAddressId = reader.getString();
                    continue;
                }
                if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedAdditionalLocation.virtualNetworkConfiguration = VirtualNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("gatewayRegionalUrl".equals(fieldName)) {
                    deserializedAdditionalLocation.gatewayRegionalUrl = reader.getString();
                    continue;
                }
                if ("natGatewayState".equals(fieldName)) {
                    deserializedAdditionalLocation.natGatewayState = NatGatewayState.fromString(reader.getString());
                    continue;
                }
                if ("outboundPublicIPAddresses".equals(fieldName)) {
                    List outboundPublicIpAddresses;
                    deserializedAdditionalLocation.outboundPublicIpAddresses = outboundPublicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableGateway".equals(fieldName)) {
                    deserializedAdditionalLocation.disableGateway = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedAdditionalLocation.platformVersion = PlatformVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdditionalLocation;
        });
    }
}

