/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;

public class ApiManagementGatewayBaseProperties
implements JsonSerializable<ApiManagementGatewayBaseProperties> {
    private String provisioningState;
    private String targetProvisioningState;
    private OffsetDateTime createdAtUtc;
    private FrontendConfiguration frontend;
    private BackendConfiguration backend;
    private GatewayConfigurationApi configurationApi;
    private VirtualNetworkType virtualNetworkType;

    public String provisioningState() {
        return this.provisioningState;
    }

    ApiManagementGatewayBaseProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    ApiManagementGatewayBaseProperties withTargetProvisioningState(String targetProvisioningState) {
        this.targetProvisioningState = targetProvisioningState;
        return this;
    }

    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    ApiManagementGatewayBaseProperties withCreatedAtUtc(OffsetDateTime createdAtUtc) {
        this.createdAtUtc = createdAtUtc;
        return this;
    }

    public FrontendConfiguration frontend() {
        return this.frontend;
    }

    public ApiManagementGatewayBaseProperties withFrontend(FrontendConfiguration frontend) {
        this.frontend = frontend;
        return this;
    }

    public BackendConfiguration backend() {
        return this.backend;
    }

    public ApiManagementGatewayBaseProperties withBackend(BackendConfiguration backend) {
        this.backend = backend;
        return this;
    }

    public GatewayConfigurationApi configurationApi() {
        return this.configurationApi;
    }

    public ApiManagementGatewayBaseProperties withConfigurationApi(GatewayConfigurationApi configurationApi) {
        this.configurationApi = configurationApi;
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.virtualNetworkType;
    }

    public ApiManagementGatewayBaseProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        this.virtualNetworkType = virtualNetworkType;
        return this;
    }

    public void validate() {
        if (this.frontend() != null) {
            this.frontend().validate();
        }
        if (this.backend() != null) {
            this.backend().validate();
        }
        if (this.configurationApi() != null) {
            this.configurationApi().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontend", (JsonSerializable)this.frontend);
        jsonWriter.writeJsonField("backend", (JsonSerializable)this.backend);
        jsonWriter.writeJsonField("configurationApi", (JsonSerializable)this.configurationApi);
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType == null ? null : this.virtualNetworkType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayBaseProperties)jsonReader.readObject(reader -> {
            ApiManagementGatewayBaseProperties deserializedApiManagementGatewayBaseProperties = new ApiManagementGatewayBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("frontend".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.frontend = FrontendConfiguration.fromJson(reader);
                    continue;
                }
                if ("backend".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.backend = BackendConfiguration.fromJson(reader);
                    continue;
                }
                if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.configurationApi = GatewayConfigurationApi.fromJson(reader);
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.virtualNetworkType = VirtualNetworkType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayBaseProperties;
        });
    }
}

