/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuPropertiesForPatch;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.time.OffsetDateTime;
import java.util.Map;

public interface ApiManagementGatewayResource {
    public String id();

    public String name();

    public String type();

    public Map<String, String> tags();

    public ApiManagementGatewaySkuProperties sku();

    public SystemData systemData();

    public String location();

    public String etag();

    public String provisioningState();

    public String targetProvisioningState();

    public OffsetDateTime createdAtUtc();

    public FrontendConfiguration frontend();

    public BackendConfiguration backend();

    public GatewayConfigurationApi configurationApi();

    public VirtualNetworkType virtualNetworkType();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ApiManagementGatewayResourceInner innerModel();

    public Update update();

    public ApiManagementGatewayResource refresh();

    public ApiManagementGatewayResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithVirtualNetworkType {
            public Update withVirtualNetworkType(VirtualNetworkType var1);
        }

        public static interface WithConfigurationApi {
            public Update withConfigurationApi(GatewayConfigurationApi var1);
        }

        public static interface WithBackend {
            public Update withBackend(BackendConfiguration var1);
        }

        public static interface WithFrontend {
            public Update withFrontend(FrontendConfiguration var1);
        }

        public static interface WithSku {
            public Update withSku(ApiManagementGatewaySkuPropertiesForPatch var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithFrontend,
    UpdateStages.WithBackend,
    UpdateStages.WithConfigurationApi,
    UpdateStages.WithVirtualNetworkType {
        public ApiManagementGatewayResource apply();

        public ApiManagementGatewayResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithVirtualNetworkType {
            public WithCreate withVirtualNetworkType(VirtualNetworkType var1);
        }

        public static interface WithConfigurationApi {
            public WithCreate withConfigurationApi(GatewayConfigurationApi var1);
        }

        public static interface WithBackend {
            public WithCreate withBackend(BackendConfiguration var1);
        }

        public static interface WithFrontend {
            public WithCreate withFrontend(FrontendConfiguration var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithFrontend,
        WithBackend,
        WithConfigurationApi,
        WithVirtualNetworkType {
            public ApiManagementGatewayResource create();

            public ApiManagementGatewayResource create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(ApiManagementGatewaySkuProperties var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

