/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayUpdateProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuPropertiesForPatch;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ApiManagementGatewayUpdateParameters
extends ApimResource {
    private ApiManagementGatewayUpdateProperties innerProperties;
    private ApiManagementGatewaySkuPropertiesForPatch sku;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ApiManagementGatewayUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiManagementGatewaySkuPropertiesForPatch sku() {
        return this.sku;
    }

    public ApiManagementGatewayUpdateParameters withSku(ApiManagementGatewaySkuPropertiesForPatch sku) {
        this.sku = sku;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApiManagementGatewayUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    public FrontendConfiguration frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    public ApiManagementGatewayUpdateParameters withFrontend(FrontendConfiguration frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    public BackendConfiguration backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    public ApiManagementGatewayUpdateParameters withBackend(BackendConfiguration backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    public GatewayConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    public ApiManagementGatewayUpdateParameters withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    public ApiManagementGatewayUpdateParameters withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayUpdateParameters)((Object)jsonReader.readObject(reader -> {
            ApiManagementGatewayUpdateParameters deserializedApiManagementGatewayUpdateParameters = new ApiManagementGatewayUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementGatewayUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.innerProperties = ApiManagementGatewayUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.sku = ApiManagementGatewaySkuPropertiesForPatch.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayUpdateParameters;
        }));
    }
}

