/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AccessType;
import java.io.IOException;

public final class ApiManagementServiceBackupRestoreParameters
implements JsonSerializable<ApiManagementServiceBackupRestoreParameters> {
    private String storageAccount;
    private String containerName;
    private String backupName;
    private AccessType accessType;
    private String accessKey;
    private String clientId;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceBackupRestoreParameters.class);

    public String storageAccount() {
        return this.storageAccount;
    }

    public ApiManagementServiceBackupRestoreParameters withStorageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public ApiManagementServiceBackupRestoreParameters withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String backupName() {
        return this.backupName;
    }

    public ApiManagementServiceBackupRestoreParameters withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    public AccessType accessType() {
        return this.accessType;
    }

    public ApiManagementServiceBackupRestoreParameters withAccessType(AccessType accessType) {
        this.accessType = accessType;
        return this;
    }

    public String accessKey() {
        return this.accessKey;
    }

    public ApiManagementServiceBackupRestoreParameters withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public ApiManagementServiceBackupRestoreParameters withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public void validate() {
        if (this.storageAccount() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccount in model ApiManagementServiceBackupRestoreParameters"));
        }
        if (this.containerName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerName in model ApiManagementServiceBackupRestoreParameters"));
        }
        if (this.backupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupName in model ApiManagementServiceBackupRestoreParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccount", this.storageAccount);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeStringField("accessType", this.accessType == null ? null : this.accessType.toString());
        jsonWriter.writeStringField("accessKey", this.accessKey);
        jsonWriter.writeStringField("clientId", this.clientId);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceBackupRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceBackupRestoreParameters)jsonReader.readObject(reader -> {
            ApiManagementServiceBackupRestoreParameters deserializedApiManagementServiceBackupRestoreParameters = new ApiManagementServiceBackupRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccount".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.storageAccount = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.containerName = reader.getString();
                    continue;
                }
                if ("backupName".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.backupName = reader.getString();
                    continue;
                }
                if ("accessType".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.accessType = AccessType.fromString(reader.getString());
                    continue;
                }
                if ("accessKey".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.accessKey = reader.getString();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.clientId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceBackupRestoreParameters;
        });
    }
}

