/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.DeveloperPortalStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.LegacyPortalStatus;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public class ApiManagementServiceBaseProperties
implements JsonSerializable<ApiManagementServiceBaseProperties> {
    private String notificationSenderEmail;
    private String provisioningState;
    private String targetProvisioningState;
    private OffsetDateTime createdAtUtc;
    private String gatewayUrl;
    private String gatewayRegionalUrl;
    private String portalUrl;
    private String managementApiUrl;
    private String scmUrl;
    private String developerPortalUrl;
    private List<HostnameConfiguration> hostnameConfigurations;
    private List<String> publicIpAddresses;
    private List<String> privateIpAddresses;
    private String publicIpAddressId;
    private PublicNetworkAccess publicNetworkAccess;
    private ConfigurationApi configurationApi;
    private VirtualNetworkConfiguration virtualNetworkConfiguration;
    private List<AdditionalLocation> additionalLocations;
    private Map<String, String> customProperties;
    private List<CertificateConfiguration> certificates;
    private Boolean enableClientCertificate;
    private NatGatewayState natGatewayState;
    private List<String> outboundPublicIpAddresses;
    private Boolean disableGateway;
    private VirtualNetworkType virtualNetworkType;
    private ApiVersionConstraint apiVersionConstraint;
    private Boolean restore;
    private List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections;
    private PlatformVersion platformVersion;
    private LegacyPortalStatus legacyPortalStatus;
    private DeveloperPortalStatus developerPortalStatus;

    public String notificationSenderEmail() {
        return this.notificationSenderEmail;
    }

    public ApiManagementServiceBaseProperties withNotificationSenderEmail(String notificationSenderEmail) {
        this.notificationSenderEmail = notificationSenderEmail;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    ApiManagementServiceBaseProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    ApiManagementServiceBaseProperties withTargetProvisioningState(String targetProvisioningState) {
        this.targetProvisioningState = targetProvisioningState;
        return this;
    }

    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    ApiManagementServiceBaseProperties withCreatedAtUtc(OffsetDateTime createdAtUtc) {
        this.createdAtUtc = createdAtUtc;
        return this;
    }

    public String gatewayUrl() {
        return this.gatewayUrl;
    }

    ApiManagementServiceBaseProperties withGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
        return this;
    }

    public String gatewayRegionalUrl() {
        return this.gatewayRegionalUrl;
    }

    ApiManagementServiceBaseProperties withGatewayRegionalUrl(String gatewayRegionalUrl) {
        this.gatewayRegionalUrl = gatewayRegionalUrl;
        return this;
    }

    public String portalUrl() {
        return this.portalUrl;
    }

    ApiManagementServiceBaseProperties withPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
        return this;
    }

    public String managementApiUrl() {
        return this.managementApiUrl;
    }

    ApiManagementServiceBaseProperties withManagementApiUrl(String managementApiUrl) {
        this.managementApiUrl = managementApiUrl;
        return this;
    }

    public String scmUrl() {
        return this.scmUrl;
    }

    ApiManagementServiceBaseProperties withScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
        return this;
    }

    public String developerPortalUrl() {
        return this.developerPortalUrl;
    }

    ApiManagementServiceBaseProperties withDeveloperPortalUrl(String developerPortalUrl) {
        this.developerPortalUrl = developerPortalUrl;
        return this;
    }

    public List<HostnameConfiguration> hostnameConfigurations() {
        return this.hostnameConfigurations;
    }

    public ApiManagementServiceBaseProperties withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        this.hostnameConfigurations = hostnameConfigurations;
        return this;
    }

    public List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    ApiManagementServiceBaseProperties withPublicIpAddresses(List<String> publicIpAddresses) {
        this.publicIpAddresses = publicIpAddresses;
        return this;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    ApiManagementServiceBaseProperties withPrivateIpAddresses(List<String> privateIpAddresses) {
        this.privateIpAddresses = privateIpAddresses;
        return this;
    }

    public String publicIpAddressId() {
        return this.publicIpAddressId;
    }

    public ApiManagementServiceBaseProperties withPublicIpAddressId(String publicIpAddressId) {
        this.publicIpAddressId = publicIpAddressId;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ApiManagementServiceBaseProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ConfigurationApi configurationApi() {
        return this.configurationApi;
    }

    public ApiManagementServiceBaseProperties withConfigurationApi(ConfigurationApi configurationApi) {
        this.configurationApi = configurationApi;
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.virtualNetworkConfiguration;
    }

    public ApiManagementServiceBaseProperties withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        this.virtualNetworkConfiguration = virtualNetworkConfiguration;
        return this;
    }

    public List<AdditionalLocation> additionalLocations() {
        return this.additionalLocations;
    }

    public ApiManagementServiceBaseProperties withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        this.additionalLocations = additionalLocations;
        return this;
    }

    public Map<String, String> customProperties() {
        return this.customProperties;
    }

    public ApiManagementServiceBaseProperties withCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public List<CertificateConfiguration> certificates() {
        return this.certificates;
    }

    public ApiManagementServiceBaseProperties withCertificates(List<CertificateConfiguration> certificates) {
        this.certificates = certificates;
        return this;
    }

    public Boolean enableClientCertificate() {
        return this.enableClientCertificate;
    }

    public ApiManagementServiceBaseProperties withEnableClientCertificate(Boolean enableClientCertificate) {
        this.enableClientCertificate = enableClientCertificate;
        return this;
    }

    public NatGatewayState natGatewayState() {
        return this.natGatewayState;
    }

    public ApiManagementServiceBaseProperties withNatGatewayState(NatGatewayState natGatewayState) {
        this.natGatewayState = natGatewayState;
        return this;
    }

    public List<String> outboundPublicIpAddresses() {
        return this.outboundPublicIpAddresses;
    }

    ApiManagementServiceBaseProperties withOutboundPublicIpAddresses(List<String> outboundPublicIpAddresses) {
        this.outboundPublicIpAddresses = outboundPublicIpAddresses;
        return this;
    }

    public Boolean disableGateway() {
        return this.disableGateway;
    }

    public ApiManagementServiceBaseProperties withDisableGateway(Boolean disableGateway) {
        this.disableGateway = disableGateway;
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.virtualNetworkType;
    }

    public ApiManagementServiceBaseProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        this.virtualNetworkType = virtualNetworkType;
        return this;
    }

    public ApiVersionConstraint apiVersionConstraint() {
        return this.apiVersionConstraint;
    }

    public ApiManagementServiceBaseProperties withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        this.apiVersionConstraint = apiVersionConstraint;
        return this;
    }

    public Boolean restore() {
        return this.restore;
    }

    public ApiManagementServiceBaseProperties withRestore(Boolean restore) {
        this.restore = restore;
        return this;
    }

    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public ApiManagementServiceBaseProperties withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public PlatformVersion platformVersion() {
        return this.platformVersion;
    }

    ApiManagementServiceBaseProperties withPlatformVersion(PlatformVersion platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    public LegacyPortalStatus legacyPortalStatus() {
        return this.legacyPortalStatus;
    }

    public ApiManagementServiceBaseProperties withLegacyPortalStatus(LegacyPortalStatus legacyPortalStatus) {
        this.legacyPortalStatus = legacyPortalStatus;
        return this;
    }

    public DeveloperPortalStatus developerPortalStatus() {
        return this.developerPortalStatus;
    }

    public ApiManagementServiceBaseProperties withDeveloperPortalStatus(DeveloperPortalStatus developerPortalStatus) {
        this.developerPortalStatus = developerPortalStatus;
        return this;
    }

    public void validate() {
        if (this.hostnameConfigurations() != null) {
            this.hostnameConfigurations().forEach(e -> e.validate());
        }
        if (this.configurationApi() != null) {
            this.configurationApi().validate();
        }
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
        if (this.additionalLocations() != null) {
            this.additionalLocations().forEach(e -> e.validate());
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.apiVersionConstraint() != null) {
            this.apiVersionConstraint().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notificationSenderEmail", this.notificationSenderEmail);
        jsonWriter.writeArrayField("hostnameConfigurations", this.hostnameConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicIpAddressId", this.publicIpAddressId);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("configurationApi", (JsonSerializable)this.configurationApi);
        jsonWriter.writeJsonField("virtualNetworkConfiguration", (JsonSerializable)this.virtualNetworkConfiguration);
        jsonWriter.writeArrayField("additionalLocations", this.additionalLocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("customProperties", this.customProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableClientCertificate", this.enableClientCertificate);
        jsonWriter.writeStringField("natGatewayState", this.natGatewayState == null ? null : this.natGatewayState.toString());
        jsonWriter.writeBooleanField("disableGateway", this.disableGateway);
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType == null ? null : this.virtualNetworkType.toString());
        jsonWriter.writeJsonField("apiVersionConstraint", (JsonSerializable)this.apiVersionConstraint);
        jsonWriter.writeBooleanField("restore", this.restore);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("legacyPortalStatus", this.legacyPortalStatus == null ? null : this.legacyPortalStatus.toString());
        jsonWriter.writeStringField("developerPortalStatus", this.developerPortalStatus == null ? null : this.developerPortalStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceBaseProperties)jsonReader.readObject(reader -> {
            ApiManagementServiceBaseProperties deserializedApiManagementServiceBaseProperties = new ApiManagementServiceBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notificationSenderEmail".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.notificationSenderEmail = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("gatewayUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.gatewayUrl = reader.getString();
                    continue;
                }
                if ("gatewayRegionalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.gatewayRegionalUrl = reader.getString();
                    continue;
                }
                if ("portalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.portalUrl = reader.getString();
                    continue;
                }
                if ("managementApiUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.managementApiUrl = reader.getString();
                    continue;
                }
                if ("scmUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.scmUrl = reader.getString();
                    continue;
                }
                if ("developerPortalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.developerPortalUrl = reader.getString();
                    continue;
                }
                if ("hostnameConfigurations".equals(fieldName)) {
                    List hostnameConfigurations;
                    deserializedApiManagementServiceBaseProperties.hostnameConfigurations = hostnameConfigurations = reader.readArray(reader1 -> HostnameConfiguration.fromJson(reader1));
                    continue;
                }
                if ("publicIPAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedApiManagementServiceBaseProperties.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateIPAddresses".equals(fieldName)) {
                    List privateIpAddresses;
                    deserializedApiManagementServiceBaseProperties.privateIpAddresses = privateIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIpAddressId".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.publicIpAddressId = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.configurationApi = ConfigurationApi.fromJson(reader);
                    continue;
                }
                if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.virtualNetworkConfiguration = VirtualNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("additionalLocations".equals(fieldName)) {
                    List additionalLocations;
                    deserializedApiManagementServiceBaseProperties.additionalLocations = additionalLocations = reader.readArray(reader1 -> AdditionalLocation.fromJson(reader1));
                    continue;
                }
                if ("customProperties".equals(fieldName)) {
                    Map customProperties;
                    deserializedApiManagementServiceBaseProperties.customProperties = customProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List certificates;
                    deserializedApiManagementServiceBaseProperties.certificates = certificates = reader.readArray(reader1 -> CertificateConfiguration.fromJson(reader1));
                    continue;
                }
                if ("enableClientCertificate".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.enableClientCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("natGatewayState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.natGatewayState = NatGatewayState.fromString(reader.getString());
                    continue;
                }
                if ("outboundPublicIPAddresses".equals(fieldName)) {
                    List outboundPublicIpAddresses;
                    deserializedApiManagementServiceBaseProperties.outboundPublicIpAddresses = outboundPublicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableGateway".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.disableGateway = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.virtualNetworkType = VirtualNetworkType.fromString(reader.getString());
                    continue;
                }
                if ("apiVersionConstraint".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.apiVersionConstraint = ApiVersionConstraint.fromJson(reader);
                    continue;
                }
                if ("restore".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.restore = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedApiManagementServiceBaseProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> RemotePrivateEndpointConnectionWrapper.fromJson(reader1));
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.platformVersion = PlatformVersion.fromString(reader.getString());
                    continue;
                }
                if ("legacyPortalStatus".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.legacyPortalStatus = LegacyPortalStatus.fromString(reader.getString());
                    continue;
                }
                if ("developerPortalStatus".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.developerPortalStatus = DeveloperPortalStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceBaseProperties;
        });
    }
}

