/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceResourceInner;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceApplyNetworkConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBackupRestoreParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetSsoTokenResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceIdentity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.DeveloperPortalStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.LegacyPortalStatus;
import com.azure.resourcemanager.apimanagement.models.MigrateToStv2Contract;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface ApiManagementServiceResource {
    public String id();

    public String name();

    public String type();

    public Map<String, String> tags();

    public ApiManagementServiceSkuProperties sku();

    public ApiManagementServiceIdentity identity();

    public SystemData systemData();

    public String location();

    public String etag();

    public List<String> zones();

    public String publisherEmail();

    public String publisherName();

    public String notificationSenderEmail();

    public String provisioningState();

    public String targetProvisioningState();

    public OffsetDateTime createdAtUtc();

    public String gatewayUrl();

    public String gatewayRegionalUrl();

    public String portalUrl();

    public String managementApiUrl();

    public String scmUrl();

    public String developerPortalUrl();

    public List<HostnameConfiguration> hostnameConfigurations();

    public List<String> publicIpAddresses();

    public List<String> privateIpAddresses();

    public String publicIpAddressId();

    public PublicNetworkAccess publicNetworkAccess();

    public ConfigurationApi configurationApi();

    public VirtualNetworkConfiguration virtualNetworkConfiguration();

    public List<AdditionalLocation> additionalLocations();

    public Map<String, String> customProperties();

    public List<CertificateConfiguration> certificates();

    public Boolean enableClientCertificate();

    public NatGatewayState natGatewayState();

    public List<String> outboundPublicIpAddresses();

    public Boolean disableGateway();

    public VirtualNetworkType virtualNetworkType();

    public ApiVersionConstraint apiVersionConstraint();

    public Boolean restore();

    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections();

    public PlatformVersion platformVersion();

    public LegacyPortalStatus legacyPortalStatus();

    public DeveloperPortalStatus developerPortalStatus();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ApiManagementServiceResourceInner innerModel();

    public Update update();

    public ApiManagementServiceResource refresh();

    public ApiManagementServiceResource refresh(Context var1);

    public ApiManagementServiceResource backup(ApiManagementServiceBackupRestoreParameters var1);

    public ApiManagementServiceResource backup(ApiManagementServiceBackupRestoreParameters var1, Context var2);

    public ApiManagementServiceResource migrateToStv2();

    public ApiManagementServiceResource migrateToStv2(MigrateToStv2Contract var1, Context var2);

    public Response<ApiManagementServiceGetSsoTokenResult> getSsoTokenWithResponse(Context var1);

    public ApiManagementServiceGetSsoTokenResult getSsoToken();

    public ApiManagementServiceResource applyNetworkConfigurationUpdates();

    public ApiManagementServiceResource applyNetworkConfigurationUpdates(ApiManagementServiceApplyNetworkConfigurationParameters var1, Context var2);

    public static interface UpdateStages {

        public static interface WithDeveloperPortalStatus {
            public Update withDeveloperPortalStatus(DeveloperPortalStatus var1);
        }

        public static interface WithLegacyPortalStatus {
            public Update withLegacyPortalStatus(LegacyPortalStatus var1);
        }

        public static interface WithPrivateEndpointConnections {
            public Update withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> var1);
        }

        public static interface WithRestore {
            public Update withRestore(Boolean var1);
        }

        public static interface WithApiVersionConstraint {
            public Update withApiVersionConstraint(ApiVersionConstraint var1);
        }

        public static interface WithVirtualNetworkType {
            public Update withVirtualNetworkType(VirtualNetworkType var1);
        }

        public static interface WithDisableGateway {
            public Update withDisableGateway(Boolean var1);
        }

        public static interface WithNatGatewayState {
            public Update withNatGatewayState(NatGatewayState var1);
        }

        public static interface WithEnableClientCertificate {
            public Update withEnableClientCertificate(Boolean var1);
        }

        public static interface WithCertificates {
            public Update withCertificates(List<CertificateConfiguration> var1);
        }

        public static interface WithCustomProperties {
            public Update withCustomProperties(Map<String, String> var1);
        }

        public static interface WithAdditionalLocations {
            public Update withAdditionalLocations(List<AdditionalLocation> var1);
        }

        public static interface WithVirtualNetworkConfiguration {
            public Update withVirtualNetworkConfiguration(VirtualNetworkConfiguration var1);
        }

        public static interface WithConfigurationApi {
            public Update withConfigurationApi(ConfigurationApi var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithPublicIpAddressId {
            public Update withPublicIpAddressId(String var1);
        }

        public static interface WithHostnameConfigurations {
            public Update withHostnameConfigurations(List<HostnameConfiguration> var1);
        }

        public static interface WithNotificationSenderEmail {
            public Update withNotificationSenderEmail(String var1);
        }

        public static interface WithPublisherName {
            public Update withPublisherName(String var1);
        }

        public static interface WithPublisherEmail {
            public Update withPublisherEmail(String var1);
        }

        public static interface WithZones {
            public Update withZones(List<String> var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ApiManagementServiceIdentity var1);
        }

        public static interface WithSku {
            public Update withSku(ApiManagementServiceSkuProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithIdentity,
    UpdateStages.WithZones,
    UpdateStages.WithPublisherEmail,
    UpdateStages.WithPublisherName,
    UpdateStages.WithNotificationSenderEmail,
    UpdateStages.WithHostnameConfigurations,
    UpdateStages.WithPublicIpAddressId,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithConfigurationApi,
    UpdateStages.WithVirtualNetworkConfiguration,
    UpdateStages.WithAdditionalLocations,
    UpdateStages.WithCustomProperties,
    UpdateStages.WithCertificates,
    UpdateStages.WithEnableClientCertificate,
    UpdateStages.WithNatGatewayState,
    UpdateStages.WithDisableGateway,
    UpdateStages.WithVirtualNetworkType,
    UpdateStages.WithApiVersionConstraint,
    UpdateStages.WithRestore,
    UpdateStages.WithPrivateEndpointConnections,
    UpdateStages.WithLegacyPortalStatus,
    UpdateStages.WithDeveloperPortalStatus {
        public ApiManagementServiceResource apply();

        public ApiManagementServiceResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDeveloperPortalStatus {
            public WithCreate withDeveloperPortalStatus(DeveloperPortalStatus var1);
        }

        public static interface WithLegacyPortalStatus {
            public WithCreate withLegacyPortalStatus(LegacyPortalStatus var1);
        }

        public static interface WithPrivateEndpointConnections {
            public WithCreate withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> var1);
        }

        public static interface WithRestore {
            public WithCreate withRestore(Boolean var1);
        }

        public static interface WithApiVersionConstraint {
            public WithCreate withApiVersionConstraint(ApiVersionConstraint var1);
        }

        public static interface WithVirtualNetworkType {
            public WithCreate withVirtualNetworkType(VirtualNetworkType var1);
        }

        public static interface WithDisableGateway {
            public WithCreate withDisableGateway(Boolean var1);
        }

        public static interface WithNatGatewayState {
            public WithCreate withNatGatewayState(NatGatewayState var1);
        }

        public static interface WithEnableClientCertificate {
            public WithCreate withEnableClientCertificate(Boolean var1);
        }

        public static interface WithCertificates {
            public WithCreate withCertificates(List<CertificateConfiguration> var1);
        }

        public static interface WithCustomProperties {
            public WithCreate withCustomProperties(Map<String, String> var1);
        }

        public static interface WithAdditionalLocations {
            public WithCreate withAdditionalLocations(List<AdditionalLocation> var1);
        }

        public static interface WithVirtualNetworkConfiguration {
            public WithCreate withVirtualNetworkConfiguration(VirtualNetworkConfiguration var1);
        }

        public static interface WithConfigurationApi {
            public WithCreate withConfigurationApi(ConfigurationApi var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithPublicIpAddressId {
            public WithCreate withPublicIpAddressId(String var1);
        }

        public static interface WithHostnameConfigurations {
            public WithCreate withHostnameConfigurations(List<HostnameConfiguration> var1);
        }

        public static interface WithNotificationSenderEmail {
            public WithCreate withNotificationSenderEmail(String var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ApiManagementServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithZones,
        WithNotificationSenderEmail,
        WithHostnameConfigurations,
        WithPublicIpAddressId,
        WithPublicNetworkAccess,
        WithConfigurationApi,
        WithVirtualNetworkConfiguration,
        WithAdditionalLocations,
        WithCustomProperties,
        WithCertificates,
        WithEnableClientCertificate,
        WithNatGatewayState,
        WithDisableGateway,
        WithVirtualNetworkType,
        WithApiVersionConstraint,
        WithRestore,
        WithPrivateEndpointConnections,
        WithLegacyPortalStatus,
        WithDeveloperPortalStatus {
            public ApiManagementServiceResource create();

            public ApiManagementServiceResource create(Context var1);
        }

        public static interface WithPublisherName {
            public WithCreate withPublisherName(String var1);
        }

        public static interface WithPublisherEmail {
            public WithPublisherName withPublisherEmail(String var1);
        }

        public static interface WithSku {
            public WithPublisherEmail withSku(ApiManagementServiceSkuProperties var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithPublisherEmail,
    DefinitionStages.WithPublisherName,
    DefinitionStages.WithCreate {
    }
}

