/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SkuType;
import java.io.IOException;

public final class ApiManagementServiceSkuProperties
implements JsonSerializable<ApiManagementServiceSkuProperties> {
    private SkuType name;
    private int capacity;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceSkuProperties.class);

    public SkuType name() {
        return this.name;
    }

    public ApiManagementServiceSkuProperties withName(SkuType name) {
        this.name = name;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    public ApiManagementServiceSkuProperties withCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ApiManagementServiceSkuProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeIntField("capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceSkuProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceSkuProperties)jsonReader.readObject(reader -> {
            ApiManagementServiceSkuProperties deserializedApiManagementServiceSkuProperties = new ApiManagementServiceSkuProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApiManagementServiceSkuProperties.name = SkuType.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedApiManagementServiceSkuProperties.capacity = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceSkuProperties;
        });
    }
}

