/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiEntityBaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;
import java.util.List;

public final class ApiTagResourceContractProperties
extends ApiEntityBaseContract {
    private String id;
    private String name;
    private String serviceUrl;
    private String path;
    private List<Protocol> protocols;
    private Boolean isOnline;

    public String id() {
        return this.id;
    }

    public ApiTagResourceContractProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ApiTagResourceContractProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public ApiTagResourceContractProperties withServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApiTagResourceContractProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public ApiTagResourceContractProperties withProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Override
    public Boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public ApiTagResourceContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        super.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        super.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiType(ApiType apiType) {
        super.withApiType(apiType);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiRevision(String apiRevision) {
        super.withApiRevision(apiRevision);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withIsCurrent(Boolean isCurrent) {
        super.withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiRevisionDescription(String apiRevisionDescription) {
        super.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiVersionDescription(String apiVersionDescription) {
        super.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withApiVersionSetId(String apiVersionSetId) {
        super.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withTermsOfServiceUrl(String termsOfServiceUrl) {
        super.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withContact(ApiContactInformation contact) {
        super.withContact(contact);
        return this;
    }

    @Override
    public ApiTagResourceContractProperties withLicense(ApiLicenseInformation license) {
        super.withLicense(license);
        return this;
    }

    @Override
    public void validate() {
        if (this.authenticationSettings() != null) {
            this.authenticationSettings().validate();
        }
        if (this.subscriptionKeyParameterNames() != null) {
            this.subscriptionKeyParameterNames().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
        if (this.license() != null) {
            this.license().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("authenticationSettings", (JsonSerializable)this.authenticationSettings());
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", (JsonSerializable)this.subscriptionKeyParameterNames());
        jsonWriter.writeStringField("type", this.apiType() == null ? null : this.apiType().toString());
        jsonWriter.writeStringField("apiRevision", this.apiRevision());
        jsonWriter.writeStringField("apiVersion", this.apiVersion());
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent());
        jsonWriter.writeStringField("apiRevisionDescription", this.apiRevisionDescription());
        jsonWriter.writeStringField("apiVersionDescription", this.apiVersionDescription());
        jsonWriter.writeStringField("apiVersionSetId", this.apiVersionSetId());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeStringField("termsOfServiceUrl", this.termsOfServiceUrl());
        jsonWriter.writeJsonField("contact", (JsonSerializable)this.contact());
        jsonWriter.writeJsonField("license", (JsonSerializable)this.license());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("serviceUrl", this.serviceUrl);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ApiTagResourceContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiTagResourceContractProperties)jsonReader.readObject(reader -> {
            ApiTagResourceContractProperties deserializedApiTagResourceContractProperties = new ApiTagResourceContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withAuthenticationSettings(AuthenticationSettingsContract.fromJson(reader));
                    continue;
                }
                if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiType(ApiType.fromString(reader.getString()));
                    continue;
                }
                if ("apiRevision".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiRevision(reader.getString());
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiVersion(reader.getString());
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withIsCurrent((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isOnline".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.isOnline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiRevisionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiVersionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withApiVersionSetId(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withTermsOfServiceUrl(reader.getString());
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withContact(ApiContactInformation.fromJson(reader));
                    continue;
                }
                if ("license".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.withLicense(ApiLicenseInformation.fromJson(reader));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.name = reader.getString();
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.serviceUrl = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedApiTagResourceContractProperties.path = reader.getString();
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols;
                    deserializedApiTagResourceContractProperties.protocols = protocols = reader.readArray(reader1 -> Protocol.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiTagResourceContractProperties;
        });
    }
}

