/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.OAuth2AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.OpenIdAuthenticationSettingsContract;
import java.io.IOException;
import java.util.List;

public final class AuthenticationSettingsContract
implements JsonSerializable<AuthenticationSettingsContract> {
    private OAuth2AuthenticationSettingsContract oAuth2;
    private OpenIdAuthenticationSettingsContract openid;
    private List<OAuth2AuthenticationSettingsContract> oAuth2AuthenticationSettings;
    private List<OpenIdAuthenticationSettingsContract> openidAuthenticationSettings;

    public OAuth2AuthenticationSettingsContract oAuth2() {
        return this.oAuth2;
    }

    public AuthenticationSettingsContract withOAuth2(OAuth2AuthenticationSettingsContract oAuth2) {
        this.oAuth2 = oAuth2;
        return this;
    }

    public OpenIdAuthenticationSettingsContract openid() {
        return this.openid;
    }

    public AuthenticationSettingsContract withOpenid(OpenIdAuthenticationSettingsContract openid) {
        this.openid = openid;
        return this;
    }

    public List<OAuth2AuthenticationSettingsContract> oAuth2AuthenticationSettings() {
        return this.oAuth2AuthenticationSettings;
    }

    public AuthenticationSettingsContract withOAuth2AuthenticationSettings(List<OAuth2AuthenticationSettingsContract> oAuth2AuthenticationSettings) {
        this.oAuth2AuthenticationSettings = oAuth2AuthenticationSettings;
        return this;
    }

    public List<OpenIdAuthenticationSettingsContract> openidAuthenticationSettings() {
        return this.openidAuthenticationSettings;
    }

    public AuthenticationSettingsContract withOpenidAuthenticationSettings(List<OpenIdAuthenticationSettingsContract> openidAuthenticationSettings) {
        this.openidAuthenticationSettings = openidAuthenticationSettings;
        return this;
    }

    public void validate() {
        if (this.oAuth2() != null) {
            this.oAuth2().validate();
        }
        if (this.openid() != null) {
            this.openid().validate();
        }
        if (this.oAuth2AuthenticationSettings() != null) {
            this.oAuth2AuthenticationSettings().forEach(e -> e.validate());
        }
        if (this.openidAuthenticationSettings() != null) {
            this.openidAuthenticationSettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("oAuth2", (JsonSerializable)this.oAuth2);
        jsonWriter.writeJsonField("openid", (JsonSerializable)this.openid);
        jsonWriter.writeArrayField("oAuth2AuthenticationSettings", this.oAuth2AuthenticationSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("openidAuthenticationSettings", this.openidAuthenticationSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AuthenticationSettingsContract fromJson(JsonReader jsonReader) throws IOException {
        return (AuthenticationSettingsContract)jsonReader.readObject(reader -> {
            AuthenticationSettingsContract deserializedAuthenticationSettingsContract = new AuthenticationSettingsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("oAuth2".equals(fieldName)) {
                    deserializedAuthenticationSettingsContract.oAuth2 = OAuth2AuthenticationSettingsContract.fromJson(reader);
                    continue;
                }
                if ("openid".equals(fieldName)) {
                    deserializedAuthenticationSettingsContract.openid = OpenIdAuthenticationSettingsContract.fromJson(reader);
                    continue;
                }
                if ("oAuth2AuthenticationSettings".equals(fieldName)) {
                    List oAuth2AuthenticationSettings;
                    deserializedAuthenticationSettingsContract.oAuth2AuthenticationSettings = oAuth2AuthenticationSettings = reader.readArray(reader1 -> OAuth2AuthenticationSettingsContract.fromJson(reader1));
                    continue;
                }
                if ("openidAuthenticationSettings".equals(fieldName)) {
                    List openidAuthenticationSettings;
                    deserializedAuthenticationSettingsContract.openidAuthenticationSettings = openidAuthenticationSettings = reader.readArray(reader1 -> OpenIdAuthenticationSettingsContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthenticationSettingsContract;
        });
    }
}

