/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.util.Map;

public interface AuthorizationContract {
    public String id();

    public String name();

    public String type();

    public AuthorizationType authorizationType();

    public OAuth2GrantType oAuth2GrantType();

    public Map<String, String> parameters();

    public AuthorizationError error();

    public String status();

    public String resourceGroupName();

    public AuthorizationContractInner innerModel();

    public Update update();

    public AuthorizationContract refresh();

    public AuthorizationContract refresh(Context var1);

    public AuthorizationsConfirmConsentCodeResponse confirmConsentCodeWithResponse(AuthorizationConfirmConsentCodeRequestContract var1, Context var2);

    public void confirmConsentCode(AuthorizationConfirmConsentCodeRequestContract var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithStatus {
            public Update withStatus(String var1);
        }

        public static interface WithError {
            public Update withError(AuthorizationError var1);
        }

        public static interface WithParameters {
            public Update withParameters(Map<String, String> var1);
        }

        public static interface WithOAuth2GrantType {
            public Update withOAuth2GrantType(OAuth2GrantType var1);
        }

        public static interface WithAuthorizationType {
            public Update withAuthorizationType(AuthorizationType var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithAuthorizationType,
    UpdateStages.WithOAuth2GrantType,
    UpdateStages.WithParameters,
    UpdateStages.WithError,
    UpdateStages.WithStatus,
    UpdateStages.WithIfMatch {
        public AuthorizationContract apply();

        public AuthorizationContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithStatus {
            public WithCreate withStatus(String var1);
        }

        public static interface WithError {
            public WithCreate withError(AuthorizationError var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, String> var1);
        }

        public static interface WithOAuth2GrantType {
            public WithCreate withOAuth2GrantType(OAuth2GrantType var1);
        }

        public static interface WithAuthorizationType {
            public WithCreate withAuthorizationType(AuthorizationType var1);
        }

        public static interface WithCreate
        extends WithAuthorizationType,
        WithOAuth2GrantType,
        WithParameters,
        WithError,
        WithStatus,
        WithIfMatch {
            public AuthorizationContract create();

            public AuthorizationContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAuthorizationProvider(String var1, String var2, String var3);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

