/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderOAuth2GrantTypes;
import java.io.IOException;

public final class AuthorizationProviderOAuth2Settings
implements JsonSerializable<AuthorizationProviderOAuth2Settings> {
    private String redirectUrl;
    private AuthorizationProviderOAuth2GrantTypes grantTypes;

    public String redirectUrl() {
        return this.redirectUrl;
    }

    public AuthorizationProviderOAuth2Settings withRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public AuthorizationProviderOAuth2GrantTypes grantTypes() {
        return this.grantTypes;
    }

    public AuthorizationProviderOAuth2Settings withGrantTypes(AuthorizationProviderOAuth2GrantTypes grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public void validate() {
        if (this.grantTypes() != null) {
            this.grantTypes().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("redirectUrl", this.redirectUrl);
        jsonWriter.writeJsonField("grantTypes", (JsonSerializable)this.grantTypes);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationProviderOAuth2Settings fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationProviderOAuth2Settings)jsonReader.readObject(reader -> {
            AuthorizationProviderOAuth2Settings deserializedAuthorizationProviderOAuth2Settings = new AuthorizationProviderOAuth2Settings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("redirectUrl".equals(fieldName)) {
                    deserializedAuthorizationProviderOAuth2Settings.redirectUrl = reader.getString();
                    continue;
                }
                if ("grantTypes".equals(fieldName)) {
                    deserializedAuthorizationProviderOAuth2Settings.grantTypes = AuthorizationProviderOAuth2GrantTypes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationProviderOAuth2Settings;
        });
    }
}

