/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationMethod;
import com.azure.resourcemanager.apimanagement.models.BearerTokenSendingMethod;
import com.azure.resourcemanager.apimanagement.models.ClientAuthenticationMethod;
import com.azure.resourcemanager.apimanagement.models.TokenBodyParameterContract;
import java.io.IOException;
import java.util.List;

public class AuthorizationServerContractBaseProperties
implements JsonSerializable<AuthorizationServerContractBaseProperties> {
    private String description;
    private List<AuthorizationMethod> authorizationMethods;
    private List<ClientAuthenticationMethod> clientAuthenticationMethod;
    private List<TokenBodyParameterContract> tokenBodyParameters;
    private String tokenEndpoint;
    private Boolean supportState;
    private String defaultScope;
    private List<BearerTokenSendingMethod> bearerTokenSendingMethods;
    private String resourceOwnerUsername;
    private String resourceOwnerPassword;

    public String description() {
        return this.description;
    }

    public AuthorizationServerContractBaseProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<AuthorizationMethod> authorizationMethods() {
        return this.authorizationMethods;
    }

    public AuthorizationServerContractBaseProperties withAuthorizationMethods(List<AuthorizationMethod> authorizationMethods) {
        this.authorizationMethods = authorizationMethods;
        return this;
    }

    public List<ClientAuthenticationMethod> clientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public AuthorizationServerContractBaseProperties withClientAuthenticationMethod(List<ClientAuthenticationMethod> clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
        return this;
    }

    public List<TokenBodyParameterContract> tokenBodyParameters() {
        return this.tokenBodyParameters;
    }

    public AuthorizationServerContractBaseProperties withTokenBodyParameters(List<TokenBodyParameterContract> tokenBodyParameters) {
        this.tokenBodyParameters = tokenBodyParameters;
        return this;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public AuthorizationServerContractBaseProperties withTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public Boolean supportState() {
        return this.supportState;
    }

    public AuthorizationServerContractBaseProperties withSupportState(Boolean supportState) {
        this.supportState = supportState;
        return this;
    }

    public String defaultScope() {
        return this.defaultScope;
    }

    public AuthorizationServerContractBaseProperties withDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
        return this;
    }

    public List<BearerTokenSendingMethod> bearerTokenSendingMethods() {
        return this.bearerTokenSendingMethods;
    }

    public AuthorizationServerContractBaseProperties withBearerTokenSendingMethods(List<BearerTokenSendingMethod> bearerTokenSendingMethods) {
        this.bearerTokenSendingMethods = bearerTokenSendingMethods;
        return this;
    }

    public String resourceOwnerUsername() {
        return this.resourceOwnerUsername;
    }

    public AuthorizationServerContractBaseProperties withResourceOwnerUsername(String resourceOwnerUsername) {
        this.resourceOwnerUsername = resourceOwnerUsername;
        return this;
    }

    public String resourceOwnerPassword() {
        return this.resourceOwnerPassword;
    }

    public AuthorizationServerContractBaseProperties withResourceOwnerPassword(String resourceOwnerPassword) {
        this.resourceOwnerPassword = resourceOwnerPassword;
        return this;
    }

    public void validate() {
        if (this.tokenBodyParameters() != null) {
            this.tokenBodyParameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("authorizationMethods", this.authorizationMethods, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("clientAuthenticationMethod", this.clientAuthenticationMethod, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("tokenBodyParameters", this.tokenBodyParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("tokenEndpoint", this.tokenEndpoint);
        jsonWriter.writeBooleanField("supportState", this.supportState);
        jsonWriter.writeStringField("defaultScope", this.defaultScope);
        jsonWriter.writeArrayField("bearerTokenSendingMethods", this.bearerTokenSendingMethods, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("resourceOwnerUsername", this.resourceOwnerUsername);
        jsonWriter.writeStringField("resourceOwnerPassword", this.resourceOwnerPassword);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationServerContractBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationServerContractBaseProperties)jsonReader.readObject(reader -> {
            AuthorizationServerContractBaseProperties deserializedAuthorizationServerContractBaseProperties = new AuthorizationServerContractBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.description = reader.getString();
                    continue;
                }
                if ("authorizationMethods".equals(fieldName)) {
                    List authorizationMethods;
                    deserializedAuthorizationServerContractBaseProperties.authorizationMethods = authorizationMethods = reader.readArray(reader1 -> AuthorizationMethod.fromString(reader1.getString()));
                    continue;
                }
                if ("clientAuthenticationMethod".equals(fieldName)) {
                    List clientAuthenticationMethod;
                    deserializedAuthorizationServerContractBaseProperties.clientAuthenticationMethod = clientAuthenticationMethod = reader.readArray(reader1 -> ClientAuthenticationMethod.fromString(reader1.getString()));
                    continue;
                }
                if ("tokenBodyParameters".equals(fieldName)) {
                    List tokenBodyParameters;
                    deserializedAuthorizationServerContractBaseProperties.tokenBodyParameters = tokenBodyParameters = reader.readArray(reader1 -> TokenBodyParameterContract.fromJson(reader1));
                    continue;
                }
                if ("tokenEndpoint".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.tokenEndpoint = reader.getString();
                    continue;
                }
                if ("supportState".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.supportState = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultScope".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.defaultScope = reader.getString();
                    continue;
                }
                if ("bearerTokenSendingMethods".equals(fieldName)) {
                    List bearerTokenSendingMethods;
                    deserializedAuthorizationServerContractBaseProperties.bearerTokenSendingMethods = bearerTokenSendingMethods = reader.readArray(reader1 -> BearerTokenSendingMethod.fromString(reader1.getString()));
                    continue;
                }
                if ("resourceOwnerUsername".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.resourceOwnerUsername = reader.getString();
                    continue;
                }
                if ("resourceOwnerPassword".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.resourceOwnerPassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationServerContractBaseProperties;
        });
    }
}

