/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BackendAuthorizationHeaderCredentials
implements JsonSerializable<BackendAuthorizationHeaderCredentials> {
    private String scheme;
    private String parameter;
    private static final ClientLogger LOGGER = new ClientLogger(BackendAuthorizationHeaderCredentials.class);

    public String scheme() {
        return this.scheme;
    }

    public BackendAuthorizationHeaderCredentials withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String parameter() {
        return this.parameter;
    }

    public BackendAuthorizationHeaderCredentials withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    public void validate() {
        if (this.scheme() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scheme in model BackendAuthorizationHeaderCredentials"));
        }
        if (this.parameter() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameter in model BackendAuthorizationHeaderCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheme", this.scheme);
        jsonWriter.writeStringField("parameter", this.parameter);
        return jsonWriter.writeEndObject();
    }

    public static BackendAuthorizationHeaderCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (BackendAuthorizationHeaderCredentials)jsonReader.readObject(reader -> {
            BackendAuthorizationHeaderCredentials deserializedBackendAuthorizationHeaderCredentials = new BackendAuthorizationHeaderCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheme".equals(fieldName)) {
                    deserializedBackendAuthorizationHeaderCredentials.scheme = reader.getString();
                    continue;
                }
                if ("parameter".equals(fieldName)) {
                    deserializedBackendAuthorizationHeaderCredentials.parameter = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendAuthorizationHeaderCredentials;
        });
    }
}

