/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendAuthorizationHeaderCredentials;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BackendCredentialsContract
implements JsonSerializable<BackendCredentialsContract> {
    private List<String> certificateIds;
    private List<String> certificate;
    private Map<String, List<String>> query;
    private Map<String, List<String>> headerProperty;
    private BackendAuthorizationHeaderCredentials authorization;

    public List<String> certificateIds() {
        return this.certificateIds;
    }

    public BackendCredentialsContract withCertificateIds(List<String> certificateIds) {
        this.certificateIds = certificateIds;
        return this;
    }

    public List<String> certificate() {
        return this.certificate;
    }

    public BackendCredentialsContract withCertificate(List<String> certificate) {
        this.certificate = certificate;
        return this;
    }

    public Map<String, List<String>> query() {
        return this.query;
    }

    public BackendCredentialsContract withQuery(Map<String, List<String>> query) {
        this.query = query;
        return this;
    }

    public Map<String, List<String>> headerProperty() {
        return this.headerProperty;
    }

    public BackendCredentialsContract withHeaderProperty(Map<String, List<String>> headerProperty) {
        this.headerProperty = headerProperty;
        return this;
    }

    public BackendAuthorizationHeaderCredentials authorization() {
        return this.authorization;
    }

    public BackendCredentialsContract withAuthorization(BackendAuthorizationHeaderCredentials authorization) {
        this.authorization = authorization;
        return this;
    }

    public void validate() {
        if (this.authorization() != null) {
            this.authorization().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificateIds", this.certificateIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificate", this.certificate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("query", this.query, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeMapField("header", this.headerProperty, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeJsonField("authorization", (JsonSerializable)this.authorization);
        return jsonWriter.writeEndObject();
    }

    public static BackendCredentialsContract fromJson(JsonReader jsonReader) throws IOException {
        return (BackendCredentialsContract)jsonReader.readObject(reader -> {
            BackendCredentialsContract deserializedBackendCredentialsContract = new BackendCredentialsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificateIds".equals(fieldName)) {
                    List certificateIds;
                    deserializedBackendCredentialsContract.certificateIds = certificateIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    List certificate;
                    deserializedBackendCredentialsContract.certificate = certificate = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("query".equals(fieldName)) {
                    Map query;
                    deserializedBackendCredentialsContract.query = query = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("header".equals(fieldName)) {
                    Map headerProperty;
                    deserializedBackendCredentialsContract.headerProperty = headerProperty = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("authorization".equals(fieldName)) {
                    deserializedBackendCredentialsContract.authorization = BackendAuthorizationHeaderCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendCredentialsContract;
        });
    }
}

