/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendPoolItem;
import java.io.IOException;
import java.util.List;

public class BackendPool
implements JsonSerializable<BackendPool> {
    private List<BackendPoolItem> services;

    public List<BackendPoolItem> services() {
        return this.services;
    }

    public BackendPool withServices(List<BackendPoolItem> services) {
        this.services = services;
        return this;
    }

    public void validate() {
        if (this.services() != null) {
            this.services().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("services", this.services, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BackendPool fromJson(JsonReader jsonReader) throws IOException {
        return (BackendPool)jsonReader.readObject(reader -> {
            BackendPool deserializedBackendPool = new BackendPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("services".equals(fieldName)) {
                    List services;
                    deserializedBackendPool.services = services = reader.readArray(reader1 -> BackendPoolItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendPool;
        });
    }
}

